/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.service.impl;

import com.codingapi.sds.socket.config.SocketConfig;
import com.codingapi.sds.socket.service.NettyServerService;
import com.codingapi.sds.socket.service.SocketService;
import com.codingapi.sds.socket.socket.SocketServerChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class NettyServerServiceImpl
implements NettyServerService {
    @Autowired
    private SocketConfig socketConfig;
    @Autowired
    private SocketService socketService;
    @Autowired
    private ApplicationContext applicationContext;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap b;
    private Logger logger = LoggerFactory.getLogger(NettyServerServiceImpl.class);

    @Override
    public synchronized void start() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            this.b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SocketServerChannelInitializer(this.socketConfig.getHeartTime(), this.socketService, this.applicationContext));
            this.b.bind(this.socketConfig.getNettyPort());
            this.logger.info("socket: " + this.socketConfig.getNettyPort() + " starting....");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        this.logger.info("socket closing....");
    }
}

