/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.service.impl;

import com.codingapi.sds.socket.config.SocketConfig;
import com.codingapi.sds.socket.model.Server;
import com.codingapi.sds.socket.service.ServerService;
import com.codingapi.sds.socket.utils.ByteUtils;
import com.codingapi.sds.socket.utils.SocketManager;
import com.codingapi.sds.socket.utils.SocketUtils;
import io.netty.channel.Channel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class ServerServiceImpl
implements ServerService {
    @Autowired
    private SocketConfig socketConfig;

    @Override
    public Server getServer() {
        Server server = new Server();
        server.setMaxCount(SocketManager.getInstance().getMaxConnection());
        server.setNowCount(SocketManager.getInstance().getNowConnection());
        server.setIp(this.socketConfig.getNettyIp());
        server.setPort(this.socketConfig.getNettyPort());
        server.setTag(this.socketConfig.getNettyTag());
        return server;
    }

    @Override
    public boolean sendHexCmd(String uniqueKey, String cmd) {
        SocketUtils.send(uniqueKey, ByteUtils.fromHexAscii(cmd));
        return true;
    }

    @Override
    public boolean sendBase64Cmd(String uniqueKey, String cmd) {
        SocketUtils.send(uniqueKey, Base64Utils.decode((byte[])cmd.getBytes()));
        return true;
    }

    @Override
    public boolean sendStrCmd(String uniqueKey, String cmd) {
        SocketUtils.send(uniqueKey, cmd.getBytes());
        return true;
    }

    @Override
    public boolean checkChannel(String uniqueKey) {
        Channel channel = SocketManager.getInstance().getChannelByUniqueKey(uniqueKey);
        return channel != null && channel.isActive();
    }
}

