/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.service.impl;

import com.codingapi.sds.socket.mq.DeliveryClient;
import com.codingapi.sds.socket.service.SocketControl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.stereotype.Service;

@Service
public class SocketControlImpl
implements SocketControl {
    private AttributeKey attributeKey = AttributeKey.valueOf((String)SocketControlImpl.class.getName());
    @Autowired
    private DeliveryClient deliveryClient;
    @Autowired
    private Registration registration;
    private String ipPort = null;

    @Override
    public String getIpPort() {
        if (this.ipPort == null) {
            String ipAddress = this.registration.getHost();
            int port = this.registration.getPort();
            this.ipPort = String.format("%s:%d", ipAddress, port);
        }
        return this.ipPort;
    }

    @Override
    public String getServiceId() {
        return this.registration.getServiceId();
    }

    @Override
    public String getInstanceId() {
        return this.registration.getServiceId();
    }

    @Override
    public String getModelName() {
        return this.getIpPort();
    }

    @Override
    public String getUniqueKey(Channel channel) {
        return channel.remoteAddress().toString();
    }

    @Override
    public String getUniqueKey(ChannelHandlerContext ctx) {
        return this.getUniqueKey(ctx.channel());
    }

    @Override
    public void bindKey(ChannelHandlerContext ctx, String key) {
        this.bindKey(ctx.channel(), key);
    }

    @Override
    public void bindKey(Channel ctx, String key) {
        Attribute attr = ctx.attr(this.attributeKey);
        if (attr != null) {
            attr.set((Object)key);
            this.deliveryClient.putKey(this.getModelName(), this.getUniqueKey(ctx), key);
        }
    }

    @Override
    public String getKey(Channel channel) {
        Attribute attr;
        if (channel != null && (attr = channel.attr(this.attributeKey)) != null) {
            return (String)attr.get();
        }
        return null;
    }

    @Override
    public String getKey(ChannelHandlerContext ctx) {
        return this.getKey(ctx.channel());
    }

    @Override
    public void resetHeartTime(Channel ctx, int heartTime) {
        ctx.pipeline().remove("SystemTimeOut");
        ctx.pipeline().addBefore("SocketHandler", "SystemTimeOut", (ChannelHandler)new IdleStateHandler((long)heartTime, (long)heartTime, (long)heartTime, TimeUnit.SECONDS));
    }
}

