/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.service.impl;

import com.codingapi.sds.socket.mq.DeliveryClient;
import com.codingapi.sds.socket.service.SocketControl;
import com.codingapi.sds.socket.service.SocketEventService;
import com.codingapi.sds.socket.service.SocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocketServiceImpl
implements SocketService {
    private Logger logger = LoggerFactory.getLogger(SocketServiceImpl.class);
    @Autowired
    private SocketControl eurekaRegistrationService;
    @Autowired
    private DeliveryClient deliveryClient;
    @Autowired
    private SocketEventService socketEventService;

    @Override
    public void create(String uniqueKey) {
        String modelName = this.eurekaRegistrationService.getIpPort();
        this.deliveryClient.add(modelName, uniqueKey);
        this.logger.info("deliveryClient-add --> modelName:" + modelName + ",uniqueKey:" + uniqueKey);
    }

    @Override
    public void remove(String uniqueKey) {
        String modelName = this.eurekaRegistrationService.getIpPort();
        this.deliveryClient.remove(modelName, uniqueKey);
        this.logger.info("deliveryClient-remove --> modelName:" + modelName + ",uniqueKey:" + uniqueKey);
    }

    @Override
    public SocketEventService getSocketEventService() {
        return this.socketEventService;
    }
}

