/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.socket;

import com.codingapi.sds.socket.protocol.DefaultProtocolDecoderService;
import com.codingapi.sds.socket.protocol.DefaultProtocolEncoderService;
import com.codingapi.sds.socket.protocol.ProtocolDecoderService;
import com.codingapi.sds.socket.protocol.ProtocolEncoderService;
import com.codingapi.sds.socket.service.SocketService;
import com.codingapi.sds.socket.socket.handler.ProtocolDecoderHandler;
import com.codingapi.sds.socket.socket.handler.ProtocolEncoderHandler;
import com.codingapi.sds.socket.socket.handler.SocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SocketServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String ByteArrayDecoder = "ByteArrayDecoder";
    public static final String ByteArrayEncoder = "ByteArrayEncoder";
    public static final String LengthFieldBasedFrameDecoder = "LengthFieldBasedFrameDecoder";
    public static final String ProtocolDecoderHandler = "ProtocolDecoderHandler";
    public static final String ProtocolEncoderHandler = "ProtocolEncoderHandler";
    public static final String SystemTimeOut = "SystemTimeOut";
    public static final String SocketHandler = "SocketHandler";
    private static Logger logger = LoggerFactory.getLogger(SocketServerChannelInitializer.class);
    private int heartTime;
    private SocketService socketService;
    private ApplicationContext applicationContext;

    public SocketServerChannelInitializer(int heartTime, SocketService socketService, ApplicationContext applicationContext) {
        this.heartTime = heartTime;
        this.socketService = socketService;
        this.applicationContext = applicationContext;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        logger.debug("initChannel-start");
        ProtocolDecoderService protocolDecoderService = null;
        ProtocolEncoderService protocolEncoderService = null;
        try {
            protocolDecoderService = (ProtocolDecoderService)this.applicationContext.getBean(ProtocolDecoderService.class);
            protocolEncoderService = (ProtocolEncoderService)this.applicationContext.getBean(ProtocolEncoderService.class);
        }
        catch (Exception e) {
            protocolDecoderService = new DefaultProtocolDecoderService();
            protocolEncoderService = new DefaultProtocolEncoderService();
        }
        logger.debug("initChannel->protocolDecoderService:" + protocolDecoderService);
        logger.debug("initChannel->protocolEncoderService:" + protocolEncoderService);
        ch.pipeline().addLast(ByteArrayDecoder, (ChannelHandler)new ByteArrayDecoder());
        ch.pipeline().addLast(ByteArrayEncoder, (ChannelHandler)new ByteArrayEncoder());
        ch.pipeline().addLast(LengthFieldBasedFrameDecoder, (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
        ch.pipeline().addLast(ProtocolDecoderHandler, (ChannelHandler)new ProtocolDecoderHandler(protocolDecoderService));
        ch.pipeline().addLast(ProtocolEncoderHandler, (ChannelHandler)new ProtocolEncoderHandler(protocolEncoderService));
        ch.pipeline().addLast(SystemTimeOut, (ChannelHandler)new IdleStateHandler((long)this.heartTime, (long)this.heartTime, (long)this.heartTime, TimeUnit.SECONDS));
        ch.pipeline().addLast(SocketHandler, (ChannelHandler)new SocketHandler(this.socketService));
        logger.debug("initChannel-end");
    }
}

