/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.socket.socket.handler;

import com.codingapi.sds.socket.service.SocketService;
import com.codingapi.sds.socket.utils.SocketManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketHandler
extends ChannelInboundHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(SocketHandler.class);
    private SocketService socketService;

    public SocketHandler(SocketService socketService) {
        this.socketService = socketService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        String uniqueKey = ctx.channel().remoteAddress().toString();
        this.socketService.getSocketEventService().onReadListener(ctx, uniqueKey, msg);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (SocketManager.getInstance().isAllowConnection()) {
            this.logger.info("connection - > " + ctx);
            SocketManager.getInstance().addClient(ctx.channel());
            String uniqueKey = ctx.channel().remoteAddress().toString();
            try {
                this.socketService.create(uniqueKey);
                this.socketService.getSocketEventService().onConnectionListener(ctx, uniqueKey);
            }
            catch (Exception e) {
                this.logger.error("error - connection - > " + e.getMessage());
                ctx.close();
            }
        } else {
            this.logger.info("not allow connection - > " + ctx + ",nowConnectionSize->" + SocketManager.getInstance().getNowConnection() + ",maxConnectionSize->" + SocketManager.getInstance().getMaxConnection());
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.info("disconnection - > " + ctx);
        String uniqueKey = ctx.channel().remoteAddress().toString();
        this.socketService.getSocketEventService().onDisConnectionListener(ctx, uniqueKey);
        SocketManager.getInstance().removeClient(ctx.channel());
        try {
            this.socketService.remove(uniqueKey);
        }
        catch (Exception e) {
            this.logger.error("error - disconnection - > " + e.getMessage());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && this.socketService.getSocketEventService().hasOpenHeartCheck()) {
            IdleStateEvent event = (IdleStateEvent)evt;
            String uniqueKey = ctx.channel().remoteAddress().toString();
            if (event.state() == IdleState.READER_IDLE) {
                this.socketService.getSocketEventService().onHeartNoReadDataListener(ctx, uniqueKey);
            } else if (event.state() == IdleState.WRITER_IDLE) {
                this.socketService.getSocketEventService().onHeartNoWriteDataListener(ctx, uniqueKey);
            } else if (event.state() == IdleState.ALL_IDLE) {
                // empty if block
            }
        }
    }
}

