/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.service.impl;

import com.codingapi.tx.Constants;
import com.codingapi.tx.aop.bean.TxTransactionInfo;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.aop.service.TransactionServer;
import com.codingapi.tx.datasource.ILCNTransactionControl;
import com.codingapi.tx.framework.task.TaskGroupManager;
import com.codingapi.tx.framework.task.TxTask;
import com.codingapi.tx.model.TxGroup;
import com.codingapi.tx.netty.service.MQTxManagerService;
import com.lorne.core.framework.exception.ServiceException;
import com.lorne.core.framework.utils.KidUtils;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="txRunningTransactionServer")
public class TxRunningTransactionServerImpl
implements TransactionServer {
    @Autowired
    private MQTxManagerService txManagerService;
    @Autowired
    private ILCNTransactionControl transactionControl;
    private Logger logger = LoggerFactory.getLogger(TxRunningTransactionServerImpl.class);

    @Override
    public Object execute(ProceedingJoinPoint point, TxTransactionInfo info) throws Throwable {
        String kid = KidUtils.generateShortUuid();
        String txGroupId = info.getTxGroupId();
        this.logger.debug("--->begin running transaction,groupId:" + txGroupId);
        long t1 = System.currentTimeMillis();
        boolean isHasIsGroup = this.transactionControl.hasGroup(txGroupId);
        TxTransactionLocal txTransactionLocal = new TxTransactionLocal();
        txTransactionLocal.setGroupId(txGroupId);
        txTransactionLocal.setHasStart(false);
        txTransactionLocal.setKid(kid);
        txTransactionLocal.setHasIsGroup(isHasIsGroup);
        txTransactionLocal.setMaxTimeOut(Constants.txServer.getCompensateMaxWaitTime());
        TxTransactionLocal.setCurrent(txTransactionLocal);
        try {
            Object res = point.proceed();
            if (!txTransactionLocal.isReadOnly()) {
                String methodStr = info.getInvocation().getMethodStr();
                TxGroup resTxGroup = this.txManagerService.addTransactionGroup(txGroupId, kid, isHasIsGroup, methodStr);
                if (!isHasIsGroup) {
                    String type = txTransactionLocal.getType();
                    TxTask waitTask = TaskGroupManager.getInstance().getTask(kid, type);
                    while (waitTask != null && !waitTask.isAwait()) {
                        TimeUnit.MILLISECONDS.sleep(1L);
                    }
                    if (resTxGroup == null && waitTask != null) {
                        waitTask.setState(-1);
                        waitTask.signalTask();
                        throw new ServiceException("update TxGroup error, groupId:" + txGroupId);
                    }
                }
            }
            Object object = res;
            return object;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            TxTransactionLocal.setCurrent(null);
            long t2 = System.currentTimeMillis();
            this.logger.debug("<---end running transaction,groupId:" + txGroupId + ",execute time:" + (t2 - t1));
        }
    }
}

