/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Maps {
    public static <K, V> Map<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = Maps.newHashMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> newHashMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = Maps.newHashMap(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> of(K key1, V value1) {
        ImmutableMap<K, V> map = new ImmutableMap<K, V>();
        map.put(key1, value1);
        return map;
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2) {
        ImmutableMap<K, V> map = new ImmutableMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = Maps.of(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = Maps.of(key1, value1, key2, value2, key3, value3);
        map.put(key3, value4);
        return map;
    }

    static class ImmutableMap<K, V>
    implements Map<K, V> {
        private K key1;
        private V value1;
        private K key2;
        private V value2;
        private K key3;
        private V value3;
        private K key4;
        private V value4;
        private int size;
        private int maxSize = 4;

        ImmutableMap() {
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object o) {
            return Objects.nonNull(this.key1) && this.key1.equals(o) || Objects.nonNull(this.key2) && this.key2.equals(o) || Objects.nonNull(this.key3) && this.key3.equals(o) || Objects.nonNull(this.key4) && this.key4.equals(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return Objects.nonNull(this.value1) && this.value1.equals(o) || Objects.nonNull(this.value2) && this.value2.equals(o) || Objects.nonNull(this.value3) && this.value3.equals(o) || Objects.nonNull(this.value4) && this.value4.equals(o);
        }

        @Override
        public V get(Object o) {
            if (!this.containsKey(o)) {
                return null;
            }
            return (V)(Objects.nonNull(this.key1) && this.key1.equals(o) ? this.value1 : (Objects.nonNull(this.key2) && this.key2.equals(o) ? this.value2 : (Objects.nonNull(this.key3) && this.key3.equals(o) ? this.value3 : (Objects.nonNull(this.key4) && this.key4.equals(o) ? this.value4 : null))));
        }

        @Override
        public V put(K k, V v) {
            if (Objects.isNull(this.key1)) {
                this.key1 = k;
                this.value1 = v;
                ++this.size;
                return v;
            }
            if (Objects.isNull(this.key2)) {
                this.key2 = k;
                this.value2 = v;
                ++this.size;
                return v;
            }
            if (Objects.isNull(this.key3)) {
                this.key3 = k;
                this.value3 = v;
                ++this.size;
                return v;
            }
            if (Objects.isNull(this.key4)) {
                this.key4 = k;
                this.value4 = v;
                ++this.size;
                return v;
            }
            int index = this.keyIndex(k);
            if (index != -1) {
                V oldV = this.getValueByKeyIndex(index);
                this.setValueByKeyIndex(index, v);
                return oldV;
            }
            throw new IllegalStateException("ImmutableMap is full.");
        }

        @Override
        public V remove(Object o) {
            if (this.containsKey(o)) {
                int index = this.keyIndex(o);
                V oldV = this.getValueByKeyIndex(index);
                this.setValueByKeyIndex(index, null);
                --this.size;
                return oldV;
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Objects.requireNonNull(map);
            int i = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (++i > this.maxSize) break;
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.size = 0;
            this.key1 = null;
            this.value1 = null;
            this.key2 = null;
            this.value2 = null;
            this.key3 = null;
            this.value3 = null;
            this.key4 = null;
            this.value4 = null;
        }

        @Override
        public Set<K> keySet() {
            return Stream.of(this.key1, this.key2, this.key3, this.key4).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Collection<V> values() {
            return Stream.of(this.value1, this.value2, this.value3, this.value4).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException("not support entey set.");
        }

        private int keyIndex(K o) {
            return Objects.nonNull(this.key1) && this.key1.equals(o) ? 1 : (Objects.nonNull(this.key2) && this.key2.equals(o) ? 2 : (Objects.nonNull(this.key3) && this.key3.equals(o) ? 3 : (Objects.nonNull(this.key4) && this.key4.equals(o) ? 4 : -1)));
        }

        private void setValueByKeyIndex(int index, V value) {
            if (index == 1) {
                this.value1 = value;
            } else if (index == 2) {
                this.value2 = value;
            } else if (index == 3) {
                this.value3 = value;
            } else if (index == 4) {
                this.value4 = value;
            }
        }

        private V getValueByKeyIndex(int index) {
            if (index == 1) {
                return this.value1;
            }
            if (index == 2) {
                return this.value2;
            }
            if (index == 3) {
                return this.value3;
            }
            if (index == 4) {
                return this.value4;
            }
            return null;
        }
    }
}

