/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util.id;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class SnowFlakeGenerator {
    private static final long START_STAMP = 1546272000000L;
    private static final int REMAIN_BIT_NUM = 22;
    private long idcId;
    private long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;
    private int idcBitLeftOffset;
    private int machineBitLeftOffset;
    private int timestampBitLeftOffset;
    private int maxSequenceValue;

    private SnowFlakeGenerator(int idcBitNum, int machineBitNum, long idcId, long machineId) {
        int sequenceBitNum = 22 - idcBitNum - machineBitNum;
        if (idcBitNum < 0 || machineBitNum <= 0 || sequenceBitNum <= 0) {
            throw new IllegalArgumentException("Error bit number");
        }
        this.maxSequenceValue = ~(-1 << sequenceBitNum);
        this.machineBitLeftOffset = sequenceBitNum;
        this.idcBitLeftOffset = machineBitNum + sequenceBitNum;
        this.timestampBitLeftOffset = idcBitNum + machineBitNum + sequenceBitNum;
        this.idcId = idcId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currentStamp = this.getTimeMill();
        if (currentStamp < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards.");
        }
        if (currentStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & (long)this.maxSequenceValue;
            if (this.sequence == 0L) {
                this.lastStamp = this.tilNextMillis();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currentStamp;
        return currentStamp - 1546272000000L << this.timestampBitLeftOffset | this.idcId << this.idcBitLeftOffset | this.machineId << this.machineBitLeftOffset | this.sequence;
    }

    private long getTimeMill() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis() {
        long timestamp = this.getTimeMill();
        while (timestamp <= this.lastStamp) {
            timestamp = this.getTimeMill();
        }
        return timestamp;
    }

    public static void main(String[] args) {
        LocalDateTime localDateTime = LocalDateTime.of(2019, 1, 1, 0, 0, 0, 0);
        System.out.println(localDateTime.toEpochSecond(ZoneOffset.ofHours(8)));
        System.out.println(System.currentTimeMillis() / 1000L);
    }

    public static class Factory {
        private static final int DEFAULT_MACHINE_BIT_NUM = 5;
        private static final int DEFAULT_IDC_BIT_NUM = 5;
        private int machineBitNum;
        private int idcBitNum;

        public Factory() {
            this.idcBitNum = 5;
            this.machineBitNum = 5;
        }

        public Factory(int machineBitNum, int idcBitNum) {
            this.idcBitNum = idcBitNum;
            this.machineBitNum = machineBitNum;
        }

        public SnowFlakeGenerator create(long idcId, long machineId) {
            return new SnowFlakeGenerator(this.idcBitNum, this.machineBitNum, idcId, machineId);
        }
    }
}

