/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.config;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="tx-lcn.client")
@Component
public class TxClientConfig {
    private Integer dtxAspectOrder = 0;
    private int resourceOrder;
    private int txManagerHeart;
    private int txManagerDelay;
    private List<String> managerAddress = Collections.singletonList("127.0.0.1:8070");
    private int chainLevel = 3;
    private long dtxTime = 30000L;
    private long tmRpcTimeout;
    private long machineId;

    private void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    private void setDtxTime(long dtxTime) {
        this.dtxTime = dtxTime;
    }

    private void setTmRpcTimeout(long timeout) {
        this.tmRpcTimeout = timeout;
    }

    public void applyTmRpcTimeout(long timeout) {
        this.setTmRpcTimeout(timeout);
    }

    public void applyDtxTime(long dtxTime) {
        this.setDtxTime(dtxTime);
    }

    public void applyMachineId(long machineId) {
        this.setMachineId(machineId);
    }

    public Integer getDtxAspectOrder() {
        return this.dtxAspectOrder;
    }

    public int getResourceOrder() {
        return this.resourceOrder;
    }

    public int getTxManagerHeart() {
        return this.txManagerHeart;
    }

    public int getTxManagerDelay() {
        return this.txManagerDelay;
    }

    public List<String> getManagerAddress() {
        return this.managerAddress;
    }

    public int getChainLevel() {
        return this.chainLevel;
    }

    public long getDtxTime() {
        return this.dtxTime;
    }

    public long getTmRpcTimeout() {
        return this.tmRpcTimeout;
    }

    public long getMachineId() {
        return this.machineId;
    }

    public void setDtxAspectOrder(Integer dtxAspectOrder) {
        this.dtxAspectOrder = dtxAspectOrder;
    }

    public void setResourceOrder(int resourceOrder) {
        this.resourceOrder = resourceOrder;
    }

    public void setTxManagerHeart(int txManagerHeart) {
        this.txManagerHeart = txManagerHeart;
    }

    public void setTxManagerDelay(int txManagerDelay) {
        this.txManagerDelay = txManagerDelay;
    }

    public void setManagerAddress(List<String> managerAddress) {
        this.managerAddress = managerAddress;
    }

    public void setChainLevel(int chainLevel) {
        this.chainLevel = chainLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxClientConfig)) {
            return false;
        }
        TxClientConfig other = (TxClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dtxAspectOrder = this.getDtxAspectOrder();
        Integer other$dtxAspectOrder = other.getDtxAspectOrder();
        if (this$dtxAspectOrder == null ? other$dtxAspectOrder != null : !((Object)this$dtxAspectOrder).equals(other$dtxAspectOrder)) {
            return false;
        }
        if (this.getResourceOrder() != other.getResourceOrder()) {
            return false;
        }
        if (this.getTxManagerHeart() != other.getTxManagerHeart()) {
            return false;
        }
        if (this.getTxManagerDelay() != other.getTxManagerDelay()) {
            return false;
        }
        List<String> this$managerAddress = this.getManagerAddress();
        List<String> other$managerAddress = other.getManagerAddress();
        if (this$managerAddress == null ? other$managerAddress != null : !((Object)this$managerAddress).equals(other$managerAddress)) {
            return false;
        }
        if (this.getChainLevel() != other.getChainLevel()) {
            return false;
        }
        if (this.getDtxTime() != other.getDtxTime()) {
            return false;
        }
        if (this.getTmRpcTimeout() != other.getTmRpcTimeout()) {
            return false;
        }
        return this.getMachineId() == other.getMachineId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dtxAspectOrder = this.getDtxAspectOrder();
        result = result * 59 + ($dtxAspectOrder == null ? 43 : ((Object)$dtxAspectOrder).hashCode());
        result = result * 59 + this.getResourceOrder();
        result = result * 59 + this.getTxManagerHeart();
        result = result * 59 + this.getTxManagerDelay();
        List<String> $managerAddress = this.getManagerAddress();
        result = result * 59 + ($managerAddress == null ? 43 : ((Object)$managerAddress).hashCode());
        result = result * 59 + this.getChainLevel();
        long $dtxTime = this.getDtxTime();
        result = result * 59 + (int)($dtxTime >>> 32 ^ $dtxTime);
        long $tmRpcTimeout = this.getTmRpcTimeout();
        result = result * 59 + (int)($tmRpcTimeout >>> 32 ^ $tmRpcTimeout);
        long $machineId = this.getMachineId();
        result = result * 59 + (int)($machineId >>> 32 ^ $machineId);
        return result;
    }

    public String toString() {
        return "TxClientConfig(dtxAspectOrder=" + this.getDtxAspectOrder() + ", resourceOrder=" + this.getResourceOrder() + ", txManagerHeart=" + this.getTxManagerHeart() + ", txManagerDelay=" + this.getTxManagerDelay() + ", managerAddress=" + this.getManagerAddress() + ", chainLevel=" + this.getChainLevel() + ", dtxTime=" + this.getDtxTime() + ", tmRpcTimeout=" + this.getTmRpcTimeout() + ", machineId=" + this.getMachineId() + ")";
    }
}

