/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.context;

import com.codingapi.txlcn.common.exception.TCGlobalContextException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.common.util.function.Supplier;
import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.core.TccTransactionInfo;
import com.codingapi.txlcn.tc.core.context.AttachmentCache;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.context.TxContext;
import com.codingapi.txlcn.tc.core.transaction.lcn.resource.LcnConnectionProxy;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.PrimaryKeysProvider;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.TableStruct;
import com.codingapi.txlcn.tracing.TracingContext;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultGlobalContext
implements TCGlobalContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalContext.class);
    private final AttachmentCache attachmentCache;
    private final List<PrimaryKeysProvider> primaryKeysProviders;
    private final TxClientConfig clientConfig;

    @Autowired
    public DefaultGlobalContext(AttachmentCache attachmentCache, TxClientConfig clientConfig, @Autowired(required=false) List<PrimaryKeysProvider> primaryKeysProviders) {
        this.attachmentCache = attachmentCache;
        this.primaryKeysProviders = primaryKeysProviders;
        this.clientConfig = clientConfig;
    }

    @Override
    public void setLcnConnection(String groupId, LcnConnectionProxy connectionProxy) {
        this.attachmentCache.attach(groupId, LcnConnectionProxy.class.getName(), connectionProxy);
    }

    @Override
    public LcnConnectionProxy getLcnConnection(String groupId) throws TCGlobalContextException {
        if (this.attachmentCache.containsKey(groupId, LcnConnectionProxy.class.getName())) {
            return (LcnConnectionProxy)this.attachmentCache.attachment(groupId, LcnConnectionProxy.class.getName());
        }
        throw new TCGlobalContextException("non exists lcn connection");
    }

    @Override
    public TccTransactionInfo tccTransactionInfo(String unitId, Supplier<TccTransactionInfo, TransactionException> supplier) throws TransactionException {
        String unitTransactionInfoKey = unitId + ".tcc.transaction";
        if (Objects.isNull(supplier)) {
            return (TccTransactionInfo)this.attachmentCache.attachment(unitTransactionInfoKey);
        }
        if (this.attachmentCache.containsKey(unitTransactionInfoKey)) {
            return (TccTransactionInfo)this.attachmentCache.attachment(unitTransactionInfoKey);
        }
        TccTransactionInfo tccTransactionInfo = (TccTransactionInfo)supplier.get();
        this.attachmentCache.attach(unitTransactionInfoKey, tccTransactionInfo);
        return tccTransactionInfo;
    }

    @Override
    public void addTxcLockId(String groupId, String unitId, Set<String> lockIdList) {
        String lockKey = unitId + ".txc.lock";
        if (this.attachmentCache.containsKey(groupId, lockKey)) {
            ((Set)this.attachmentCache.attachment(groupId, lockKey)).addAll(lockIdList);
            return;
        }
        HashSet<String> lockList = new HashSet<String>(lockIdList);
        this.attachmentCache.attach(groupId, lockKey, lockList);
    }

    @Override
    public Set<String> findTxcLockSet(String groupId, String unitId) throws TCGlobalContextException {
        String lockKey = unitId + ".txc.lock";
        if (this.attachmentCache.containsKey(groupId, lockKey)) {
            return (Set)this.attachmentCache.attachment(groupId, lockKey);
        }
        throw new TCGlobalContextException("non exists lock id.");
    }

    @Override
    public TableStruct tableStruct(String table, Supplier<TableStruct, SQLException> structSupplier) throws SQLException {
        String tableStructKey = table + ".struct";
        if (this.attachmentCache.containsKey(tableStructKey)) {
            log.debug("cache hit! table {}'s struct.", (Object)table);
            return (TableStruct)this.attachmentCache.attachment(tableStructKey);
        }
        TableStruct tableStruct = (TableStruct)structSupplier.get();
        if (Objects.nonNull(this.primaryKeysProviders)) {
            this.primaryKeysProviders.forEach(primaryKeysProvider -> {
                List<String> users = primaryKeysProvider.provide().get(table);
                if (Objects.nonNull(users)) {
                    List<String> primaryKes = tableStruct.getPrimaryKeys();
                    primaryKes.addAll(users.stream().filter(key -> !primaryKes.contains(key)).filter(key -> tableStruct.getColumns().keySet().contains(key)).collect(Collectors.toList()));
                    tableStruct.setPrimaryKeys(primaryKes);
                }
            });
        }
        this.attachmentCache.attach(tableStructKey, tableStruct);
        return tableStruct;
    }

    @Override
    public TxContext startTx() {
        TxContext txContext = new TxContext();
        txContext.setDtxStart(!TracingContext.tracing().hasGroup());
        if (txContext.isDtxStart()) {
            TracingContext.tracing().beginTransactionGroup();
        }
        txContext.setGroupId(TracingContext.tracing().groupId());
        String txContextKey = txContext.getGroupId() + ".dtx";
        this.attachmentCache.attach(txContextKey, txContext);
        log.debug("Start TxContext[{}]", (Object)txContext.getGroupId());
        return txContext;
    }

    @Override
    public void destroyTx(String groupId) {
        this.attachmentCache.remove(groupId + ".dtx");
        log.debug("Destroy TxContext[{}]", (Object)groupId);
    }

    @Override
    public TxContext txContext(String groupId) {
        return (TxContext)this.attachmentCache.attachment(groupId + ".dtx");
    }

    @Override
    public TxContext txContext() {
        return this.txContext(TracingContext.tracing().groupId());
    }

    @Override
    public void destroyTx() {
        if (!this.hasTxContext()) {
            throw new IllegalStateException("non TxContext.");
        }
        this.destroyTx(this.txContext().getGroupId());
    }

    @Override
    public boolean hasTxContext() {
        return TracingContext.tracing().hasGroup() && this.txContext(TracingContext.tracing().groupId()) != null;
    }

    @Override
    public boolean isDTXTimeout() {
        if (!this.hasTxContext()) {
            throw new IllegalStateException("non TxContext.");
        }
        return System.currentTimeMillis() - this.txContext().getCreateTime() >= this.clientConfig.getDtxTime();
    }

    @Override
    public int dtxState(String groupId) {
        return this.attachmentCache.containsKey(groupId, "rollback-only") ? 0 : 1;
    }

    @Override
    public void setRollbackOnly(String groupId) {
        this.attachmentCache.attach(groupId, "rollback-only", true);
    }

    @Override
    public void clearGroup(String groupId) {
        this.attachmentCache.removeAll(groupId);
    }
}

