/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy;

import com.codingapi.txlcn.tc.core.transaction.txc.analy.TxcModifiedRecordListHandler;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.TxcSqlExecutor;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.DeleteImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.ModifiedRecord;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.SelectImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.StatementInfo;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.UpdateImageParams;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxcSqlExecutorImpl
implements TxcSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(TxcSqlExecutorImpl.class);
    private final QueryRunner queryRunner;

    @Autowired
    public TxcSqlExecutorImpl(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    @Override
    public List<ModifiedRecord> updateSqlPreviousData(Connection connection, UpdateImageParams updateImageParams) throws SQLException {
        String beforeSql = "SELECT " + String.join((CharSequence)", ", updateImageParams.getColumns()) + ", " + String.join((CharSequence)", ", updateImageParams.getPrimaryKeys()) + " FROM " + String.join((CharSequence)", ", updateImageParams.getTables()) + " WHERE " + updateImageParams.getWhereSql();
        return (List)this.queryRunner.query(connection, beforeSql, (ResultSetHandler)new TxcModifiedRecordListHandler(updateImageParams.getPrimaryKeys(), updateImageParams.getColumns()));
    }

    @Override
    public List<ModifiedRecord> deleteSqlPreviousData(Connection connection, DeleteImageParams deleteImageParams) throws SQLException {
        String beforeSql = "SELECT " + String.join((CharSequence)", ", deleteImageParams.getColumns()) + " FROM " + String.join((CharSequence)", ", deleteImageParams.getTables()) + " WHERE " + deleteImageParams.getSqlWhere();
        return (List)this.queryRunner.query(connection, beforeSql, (ResultSetHandler)new TxcModifiedRecordListHandler(deleteImageParams.getPrimaryKeys(), deleteImageParams.getColumns()));
    }

    @Override
    public List<ModifiedRecord> selectSqlPreviousPrimaryKeys(Connection connection, SelectImageParams selectImageParams) throws SQLException {
        return (List)this.queryRunner.query(connection, selectImageParams.getSql(), (ResultSetHandler)new TxcModifiedRecordListHandler(selectImageParams.getPrimaryKeys(), selectImageParams.getPrimaryKeys()));
    }

    @Override
    public void applyUndoLog(List<StatementInfo> statementInfoList) throws SQLException {
        Connection connection = null;
        try {
            connection = this.queryRunner.getDataSource().getConnection();
            connection.setAutoCommit(false);
            for (StatementInfo statementInfo : statementInfoList) {
                log.debug("txc > Apply undo log. sql: {}, params: {}", (Object)statementInfo.getSql(), (Object)statementInfo.getParams());
                this.queryRunner.update(connection, statementInfo.getSql(), statementInfo.getParams());
            }
            connection.commit();
        }
        catch (SQLException e) {
            if (connection != null) {
                connection.rollback();
            }
            throw e;
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
                DbUtils.close((Connection)connection);
            }
        }
    }
}

