/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.control;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TxcLogicException;
import com.codingapi.txlcn.tc.core.TransactionCleanService;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.TxcService;
import com.codingapi.txlcn.tc.txmsg.TMReporter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxcTransactionCleanService
implements TransactionCleanService {
    private static final Logger log = LoggerFactory.getLogger(TxcTransactionCleanService.class);
    private final TxcService txcService;
    private final TMReporter tmReporter;

    @Autowired
    public TxcTransactionCleanService(TxcService txcService, TMReporter tmReporter) {
        this.txcService = txcService;
        this.tmReporter = tmReporter;
    }

    @Override
    public void clear(String groupId, int state, String unitId, String unitType) throws TransactionClearException {
        boolean rethrowTxcException = false;
        try {
            if (state == 0) {
                this.txcService.undo(groupId, unitId);
            }
        }
        catch (TxcLogicException e) {
            List statementInfoList = (List)e.getAttachment();
            this.tmReporter.reportTxcUndoException(groupId, unitId, statementInfoList);
            rethrowTxcException = true;
            log.debug("need compensation !");
        }
        try {
            this.txcService.cleanTxc(groupId, unitId);
        }
        catch (TxcLogicException e) {
            throw new TransactionClearException((Throwable)e);
        }
        if (rethrowTxcException) {
            throw TransactionClearException.needCompensation();
        }
    }
}

