/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.corelog.aspect;

import com.codingapi.txlcn.tc.corelog.H2DbHelper;
import com.codingapi.txlcn.tc.corelog.LogHelper;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AspectLogHelper
implements LogHelper {
    private static final Logger log = LoggerFactory.getLogger(AspectLogHelper.class);
    private final H2DbHelper h2DbHelper;
    private final ResultSetHandler<AspectLog> resultSetHandler = resultSet -> {
        if (resultSet.next()) {
            return this.fill(resultSet);
        }
        return null;
    };

    @Autowired
    public AspectLogHelper(H2DbHelper h2DbHelper) {
        this.h2DbHelper = h2DbHelper;
    }

    public void init() {
        this.h2DbHelper.update("CREATE TABLE IF NOT EXISTS TXLCN_LOG (ID BIGINT NOT NULL AUTO_INCREMENT, UNIT_ID VARCHAR(32) NOT NULL,GROUP_ID VARCHAR(64) NOT NULL,METHOD_STR VARCHAR(512) NOT NULL ,BYTES BLOB NOT NULL,GROUP_ID_HASH BIGINT NOT NULL,UNIT_ID_HASH BIGINT NOT NULL,TIME BIGINT NOT NULL, PRIMARY KEY(ID) )", new Object[0]);
        log.info("Aspect log table finished (H2 DATABASE)");
    }

    public boolean save(AspectLog txLog) {
        String insertSql = "INSERT INTO TXLCN_LOG(UNIT_ID,GROUP_ID,BYTES,METHOD_STR,GROUP_ID_HASH,UNIT_ID_HASH,TIME) VALUES(?,?,?,?,?,?,?)";
        return this.h2DbHelper.update(insertSql, txLog.getUnitId(), txLog.getGroupId(), txLog.getBytes(), txLog.getMethodStr(), txLog.getGroupId().hashCode(), txLog.getUnitId().hashCode(), txLog.getTime()) > 0;
    }

    public boolean deleteAll() {
        String sql = "DELETE FROM TXLCN_LOG";
        return this.h2DbHelper.update(sql, new Object[0]) > 0;
    }

    public void trancute() {
        String sql = "TRUNCATE TABLE TXLCN_LOG";
        this.h2DbHelper.update(sql, new Object[0]);
    }

    public boolean delete(long id) {
        String sql = "DELETE FROM TXLCN_LOG WHERE ID = ?";
        return this.h2DbHelper.update(sql, id) > 0;
    }

    public boolean delete(long groupIdHash, long unitIdHash) {
        String sql = "DELETE FROM TXLCN_LOG WHERE GROUP_ID_HASH = ? and UNIT_ID_HASH = ?";
        return this.h2DbHelper.update(sql, groupIdHash, unitIdHash) > 0;
    }

    public boolean delete(String groupId) {
        String sql = "DELETE FROM TXLCN_LOG WHERE GROUP_ID = ?";
        return this.h2DbHelper.update(sql, groupId) > 0;
    }

    public List<AspectLog> findAll() {
        String sql = "SELECT * FROM TXLCN_LOG";
        return (List)this.h2DbHelper.query(sql, resultSet -> {
            ArrayList<AspectLog> list = new ArrayList<AspectLog>();
            while (resultSet.next()) {
                list.add(this.fill(resultSet));
            }
            return list;
        }, new Object[0]);
    }

    public long count() {
        String sql = "SELECT count(*) FROM TXLCN_LOG";
        return (Long)this.h2DbHelper.query(sql, new ScalarHandler(), new Object[0]);
    }

    public AspectLog getTxLog(String groupId, String unitId) {
        String sql = "SELECT * FROM TXLCN_LOG WHERE GROUP_ID = ? and UNIT_ID = ?";
        return this.h2DbHelper.query(sql, this.resultSetHandler, groupId, unitId);
    }

    public AspectLog getTxLog(long id) {
        String sql = "SELECT * FROM TXLCN_LOG WHERE ID = ?";
        return this.h2DbHelper.query(sql, this.resultSetHandler, id);
    }

    private AspectLog fill(ResultSet resultSet) throws SQLException {
        AspectLog txLog = new AspectLog();
        txLog.setBytes(resultSet.getBytes("BYTES"));
        txLog.setGroupId(resultSet.getString("GROUP_ID"));
        txLog.setMethodStr(resultSet.getString("METHOD_STR"));
        txLog.setTime(resultSet.getLong("TIME"));
        txLog.setUnitId(resultSet.getString("UNIT_ID"));
        txLog.setGroupIdHash(resultSet.getLong("GROUP_ID_HASH"));
        txLog.setUnitIdHash(resultSet.getLong("UNIT_ID_HASH"));
        txLog.setId(resultSet.getLong("ID"));
        return txLog;
    }
}

