/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.common.util.id.IdGenInit;
import com.codingapi.txlcn.common.util.id.ModIdProvider;
import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.support.listener.RpcEnvStatusListener;
import com.codingapi.txlcn.tc.txmsg.MessageCreator;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.listener.ClientInitCallBack;
import com.codingapi.txlcn.txmsg.listener.HeartbeatListener;
import com.codingapi.txlcn.txmsg.params.InitClientParams;
import com.codingapi.txlcn.txmsg.util.MessageUtils;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TCSideRpcInitCallBack
implements ClientInitCallBack,
HeartbeatListener {
    private static final Logger log = LoggerFactory.getLogger(TCSideRpcInitCallBack.class);
    private final RpcClient rpcClient;
    private final TxClientConfig txClientConfig;
    private final List<RpcEnvStatusListener> rpcEnvStatusListeners;
    private final ModIdProvider modIdProvider;
    private final String applicationName;

    @Autowired
    public TCSideRpcInitCallBack(RpcClient rpcClient, TxClientConfig txClientConfig, ConfigurableEnvironment environment, List<RpcEnvStatusListener> rpcEnvStatusListeners, ModIdProvider modIdProvider) {
        this.rpcClient = rpcClient;
        this.txClientConfig = txClientConfig;
        this.rpcEnvStatusListeners = rpcEnvStatusListeners;
        this.modIdProvider = modIdProvider;
        String appName = environment.getProperty("spring.application.name");
        this.applicationName = StringUtils.hasText((String)appName) ? appName : "application";
    }

    public void connected(String remoteKey) {
        this.rpcEnvStatusListeners.forEach(rpcEnvStatusListener -> rpcEnvStatusListener.onConnected(remoteKey));
        new Thread(() -> {
            try {
                log.info("Send init message to TM[{}]", (Object)remoteKey);
                MessageDto msg = this.rpcClient.request(remoteKey, MessageCreator.initClient(this.applicationName, this.modIdProvider.modId()), 5000L);
                if (MessageUtils.statusOk((MessageDto)msg)) {
                    InitClientParams resParams = (InitClientParams)msg.loadBean(InitClientParams.class);
                    this.txClientConfig.applyDtxTime(resParams.getDtxTime());
                    this.txClientConfig.applyTmRpcTimeout(resParams.getTmRpcTimeout());
                    this.txClientConfig.applyMachineId(resParams.getMachineId());
                    IdGenInit.applyDefaultIdGen((int)resParams.getSeqLen(), (long)resParams.getMachineId());
                    log.info("Finally, determined dtx time is {}ms, tm rpc timeout is {} ms, machineId is {}", new Object[]{resParams.getDtxTime(), resParams.getTmRpcTimeout(), resParams.getMachineId()});
                    this.rpcEnvStatusListeners.forEach(rpcEnvStatusListener -> rpcEnvStatusListener.onInitialized(remoteKey));
                    return;
                }
                log.error("TM[{}] exception. connect fail!", (Object)remoteKey);
            }
            catch (RpcException e) {
                log.error("Send init message exception: {}. connect fail!", (Object)e.getMessage());
            }
        }).start();
    }

    public void connectFail(String remoteKey) {
        this.rpcEnvStatusListeners.forEach(rpcEnvStatusListener -> rpcEnvStatusListener.onConnectFail(remoteKey));
    }

    public void onTcReceivedHeart(RpcCmd cmd) {
        cmd.getMsg().setData((Serializable)Long.valueOf(this.txClientConfig.getMachineId()));
    }
}

