/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.restapi.auth;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.support.restapi.auth.sauth.token.TokenStorage;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTokenStorage
implements TokenStorage {
    private final FastStorage fastStorage;

    @Autowired
    public DefaultTokenStorage(FastStorage fastStorage) {
        this.fastStorage = fastStorage;
    }

    @Override
    public boolean exist(String token) {
        try {
            List<String> tokens = this.fastStorage.findTokens();
            return tokens.contains(token);
        }
        catch (FastStorageException e) {
            return false;
        }
    }

    @Override
    public void add(String token) {
        try {
            this.fastStorage.saveToken(token);
        }
        catch (FastStorageException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove(String token) {
        try {
            this.fastStorage.removeToken(token);
        }
        catch (FastStorageException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clear() {
        try {
            for (String s : this.fastStorage.findTokens()) {
                this.fastStorage.removeToken(s);
            }
        }
        catch (FastStorageException e) {
            throw new IllegalStateException(e);
        }
    }
}

