/*
 * Decompiled with CFR 0.152.
 */
package com.codingfeline.buildkonfig.compiler.generator;

import com.codingfeline.buildkonfig.compiler.TargetConfigFile;
import com.codingfeline.buildkonfig.compiler.generator.BuildKonfigGenerator;
import com.squareup.kotlinpoet.FileSpec;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jq\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2)\u0010\u000e\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u000fj\u0002`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000fj\u0002`\u0017Ji\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2)\u0010\u000e\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u000fj\u0002`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000fj\u0002`\u0017Ji\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2)\u0010\u000e\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u000fj\u0002`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000fj\u0002`\u0017J\u0018\u0010\u001a\u001a\u00020\u0005*\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/codingfeline/buildkonfig/compiler/generator/BuildKonfigCompiler;", "", "<init>", "()V", "compileCommonObject", "", "packageName", "", "objectName", "exposeObject", "", "configFile", "Lcom/codingfeline/buildkonfig/compiler/TargetConfigFile;", "hasJsTarget", "output", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "fileName", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Lcom/codingfeline/buildkonfig/compiler/generator/FileAppender;", "logger", "Lcom/codingfeline/buildkonfig/compiler/Logger;", "compileCommon", "compileTarget", "writeToAndClose", "Lcom/squareup/kotlinpoet/FileSpec;", "appendable", "getPackageDirectory", "getOutputDirectory", "buildkonfig-compiler"})
public final class BuildKonfigCompiler {
    @NotNull
    public static final BuildKonfigCompiler INSTANCE = new BuildKonfigCompiler();

    private BuildKonfigCompiler() {
    }

    public final void compileCommonObject(@NotNull String packageName, @NotNull String objectName, boolean exposeObject, @NotNull TargetConfigFile configFile, boolean hasJsTarget, @NotNull Function1<? super String, ? extends Appendable> output, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        String outputDirectory = this.getOutputDirectory(configFile, packageName);
        FileSpec konfigFile = BuildKonfigGenerator.Companion.ofCommonObject(configFile, exposeObject, hasJsTarget, logger).generateFile(packageName, objectName);
        this.writeToAndClose(konfigFile, (Appendable)output.invoke((Object)(outputDirectory + '/' + objectName + ".kt")));
    }

    public final void compileCommon(@NotNull String packageName, @NotNull String objectName, boolean exposeObject, @NotNull TargetConfigFile configFile, @NotNull Function1<? super String, ? extends Appendable> output, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        String outputDirectory = this.getOutputDirectory(configFile, packageName);
        FileSpec konfigFile = BuildKonfigGenerator.Companion.ofCommon(configFile, exposeObject, logger).generateFile(packageName, objectName);
        this.writeToAndClose(konfigFile, (Appendable)output.invoke((Object)(outputDirectory + '/' + objectName + ".kt")));
    }

    public final void compileTarget(@NotNull String packageName, @NotNull String objectName, boolean exposeObject, @NotNull TargetConfigFile configFile, @NotNull Function1<? super String, ? extends Appendable> output, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        String outputDirectory = this.getOutputDirectory(configFile, packageName);
        FileSpec konfigFile = BuildKonfigGenerator.Companion.ofTarget(configFile, exposeObject, logger).generateFile(packageName, objectName);
        this.writeToAndClose(konfigFile, (Appendable)output.invoke((Object)(outputDirectory + '/' + objectName + ".kt")));
    }

    private final void writeToAndClose(FileSpec $this$writeToAndClose, Appendable appendable) {
        $this$writeToAndClose.writeTo(appendable);
        if (appendable instanceof Closeable) {
            ((Closeable)((Object)appendable)).close();
        }
    }

    private final String getPackageDirectory(String packageName) {
        return StringsKt.replace$default((String)packageName, (String)".", (String)"/", (boolean)false, (int)4, null);
    }

    private final String getOutputDirectory(TargetConfigFile configFile, String packageName) {
        return configFile.getOutputDirectory().getAbsolutePath() + '/' + this.getPackageDirectory(packageName);
    }
}

