/*
 * Decompiled with CFR 0.152.
 */
package com.codingfeline.buildkonfig.compiler.generator;

import com.codingfeline.buildkonfig.compiler.FieldSpec;
import com.codingfeline.buildkonfig.compiler.PlatformType;
import com.codingfeline.buildkonfig.compiler.TargetConfig;
import com.codingfeline.buildkonfig.compiler.TargetConfigFile;
import com.codingfeline.buildkonfig.compiler.generator.BuildKonfigGeneratorKt;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #2\u00020\u0001:\u0001#BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/codingfeline/buildkonfig/compiler/generator/BuildKonfigGenerator;", "", "file", "Lcom/codingfeline/buildkonfig/compiler/TargetConfigFile;", "objectAnnotations", "", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "objectModifiers", "Lcom/squareup/kotlinpoet/KModifier;", "propertyModifiers", "logger", "Lkotlin/Function1;", "", "", "Lcom/codingfeline/buildkonfig/compiler/Logger;", "<init>", "(Lcom/codingfeline/buildkonfig/compiler/TargetConfigFile;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getFile", "()Lcom/codingfeline/buildkonfig/compiler/TargetConfigFile;", "getObjectAnnotations", "()Ljava/util/List;", "getObjectModifiers", "getPropertyModifiers", "getLogger", "()Lkotlin/jvm/functions/Function1;", "generateFile", "Lcom/squareup/kotlinpoet/FileSpec;", "packageName", "objectName", "generateType", "Lcom/squareup/kotlinpoet/TypeSpec;", "generateProp", "Lcom/squareup/kotlinpoet/PropertySpec;", "fieldSpec", "Lcom/codingfeline/buildkonfig/compiler/FieldSpec;", "Companion", "buildkonfig-compiler"})
@SourceDebugExtension(value={"SMAP\nBuildKonfigGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildKonfigGenerator.kt\ncom/codingfeline/buildkonfig/compiler/generator/BuildKonfigGenerator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n37#2,2:146\n1557#3:148\n1628#3,3:149\n*S KotlinDebug\n*F\n+ 1 BuildKonfigGenerator.kt\ncom/codingfeline/buildkonfig/compiler/generator/BuildKonfigGenerator\n*L\n29#1:146,2\n33#1:148\n33#1:149,3\n*E\n"})
public abstract class BuildKonfigGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetConfigFile file;
    @NotNull
    private final List<AnnotationSpec> objectAnnotations;
    @NotNull
    private final List<KModifier> objectModifiers;
    @NotNull
    private final List<KModifier> propertyModifiers;
    @NotNull
    private final Function1<String, Unit> logger;

    public BuildKonfigGenerator(@NotNull TargetConfigFile file, @NotNull List<AnnotationSpec> objectAnnotations, @NotNull List<? extends KModifier> objectModifiers, @NotNull List<? extends KModifier> propertyModifiers, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(objectAnnotations, (String)"objectAnnotations");
        Intrinsics.checkNotNullParameter(objectModifiers, (String)"objectModifiers");
        Intrinsics.checkNotNullParameter(propertyModifiers, (String)"propertyModifiers");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.file = file;
        this.objectAnnotations = objectAnnotations;
        this.objectModifiers = objectModifiers;
        this.propertyModifiers = propertyModifiers;
        this.logger = logger;
    }

    @NotNull
    public final TargetConfigFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<AnnotationSpec> getObjectAnnotations() {
        return this.objectAnnotations;
    }

    @NotNull
    public final List<KModifier> getObjectModifiers() {
        return this.objectModifiers;
    }

    @NotNull
    public final List<KModifier> getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @NotNull
    public final Function1<String, Unit> getLogger() {
        return this.logger;
    }

    @NotNull
    public final FileSpec generateFile(@NotNull String packageName, @NotNull String objectName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, objectName);
        builder.addType(this.generateType(objectName));
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateType(String objectName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$toTypedArray$iv = this.objectModifiers;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KModifier[] kModifierArray = thisCollection$iv.toArray(new KModifier[0]);
        TypeSpec.Builder obj = TypeSpec.Companion.objectBuilder(objectName).addModifiers(Arrays.copyOf(kModifierArray, kModifierArray.length)).addAnnotations((Iterable)this.objectAnnotations);
        TargetConfig targetConfig = this.file.getConfig();
        if (targetConfig == null) {
            String $i$f$toTypedArray2 = "Required value was null.";
            throw new IllegalArgumentException($i$f$toTypedArray2.toString());
        }
        $this$toTypedArray$iv = targetConfig.getFieldSpecs().values();
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldSpec fieldSpec = (FieldSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.generateProp((FieldSpec)it));
        }
        List props = (List)destination$iv$iv;
        obj.addProperties((Iterable)props);
        return obj.build();
    }

    @NotNull
    public abstract PropertySpec generateProp(@NotNull FieldSpec var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fJ.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fJ.\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f\u00a8\u0006\u0012"}, d2={"Lcom/codingfeline/buildkonfig/compiler/generator/BuildKonfigGenerator$Companion;", "", "<init>", "()V", "ofCommonObject", "Lcom/codingfeline/buildkonfig/compiler/generator/BuildKonfigGenerator;", "file", "Lcom/codingfeline/buildkonfig/compiler/TargetConfigFile;", "exposeObject", "", "hasJsTarget", "logger", "Lkotlin/Function1;", "", "", "Lcom/codingfeline/buildkonfig/compiler/Logger;", "ofCommon", "ofTarget", "buildkonfig-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuildKonfigGenerator ofCommonObject(@NotNull TargetConfigFile file, boolean exposeObject, boolean hasJsTarget, @NotNull Function1<? super String, Unit> logger) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(logger, (String)"logger");
            List objectModifiers = CollectionsKt.listOf((Object)BuildKonfigGeneratorKt.access$getVisibilityModifier(exposeObject));
            List annotations = exposeObject && hasJsTarget ? BuildKonfigGeneratorKt.access$getJsObjectAnnotations() : CollectionsKt.emptyList();
            List list = CollectionsKt.emptyList();
            return new BuildKonfigGenerator(file, (List<AnnotationSpec>)annotations, (List<? extends KModifier>)objectModifiers, logger, list){

                public PropertySpec generateProp(FieldSpec fieldSpec) {
                    Intrinsics.checkNotNullParameter((Object)fieldSpec, (String)"fieldSpec");
                    Object[] objectArray = new Object[]{fieldSpec.getValue()};
                    PropertySpec.Builder builder = PropertySpec.Companion.builder(fieldSpec.getName(), fieldSpec.getTypeName(), new KModifier[0]).initializer(fieldSpec.getTemplate(), objectArray);
                    Collection $this$toTypedArray$iv = this.getPropertyModifiers();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    objectArray = thisCollection$iv.toArray(new KModifier[0]);
                    PropertySpec.Builder spec = builder.addModifiers((KModifier[])Arrays.copyOf(objectArray, objectArray.length));
                    if (fieldSpec.getConst()) {
                        objectArray = new KModifier[]{KModifier.CONST};
                        spec.addModifiers((KModifier[])objectArray);
                    }
                    return spec.build();
                }
            };
        }

        @NotNull
        public final BuildKonfigGenerator ofCommon(@NotNull TargetConfigFile file, boolean exposeObject, @NotNull Function1<? super String, Unit> logger) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(logger, (String)"logger");
            Object object = new KModifier[]{KModifier.EXPECT, BuildKonfigGeneratorKt.access$getVisibilityModifier(exposeObject)};
            List objectModifiers = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.emptyList();
            List list = CollectionsKt.emptyList();
            return new BuildKonfigGenerator(file, objectModifiers, logger, (List<AnnotationSpec>)object, list){

                public PropertySpec generateProp(FieldSpec fieldSpec) {
                    Intrinsics.checkNotNullParameter((Object)fieldSpec, (String)"fieldSpec");
                    Collection $this$toTypedArray$iv = this.getPropertyModifiers();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new KModifier[0]);
                    PropertySpec.Builder spec = PropertySpec.Companion.builder(fieldSpec.getName(), fieldSpec.getTypeName(), new KModifier[0]).addModifiers(Arrays.copyOf(objectArray, objectArray.length));
                    if (fieldSpec.getConst()) {
                        objectArray = new KModifier[]{KModifier.CONST};
                        PropertySpec.Builder builder = spec.addModifiers((KModifier[])objectArray);
                        objectArray = new String[]{"Suppress"};
                        ClassName className = new ClassName("kotlin", (String[])objectArray);
                        objectArray = new Object[]{"CONST_VAL_WITHOUT_INITIALIZER"};
                        builder.addAnnotation(AnnotationSpec.Companion.builder(className).addMember("%S", objectArray).build());
                    }
                    return spec.build();
                }
            };
        }

        @NotNull
        public final BuildKonfigGenerator ofTarget(@NotNull TargetConfigFile file, boolean exposeObject, @NotNull Function1<? super String, Unit> logger) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(logger, (String)"logger");
            Object[] objectArray = new KModifier[]{KModifier.ACTUAL, BuildKonfigGeneratorKt.access$getVisibilityModifier(exposeObject)};
            List objectModifiers = CollectionsKt.listOf((Object[])objectArray);
            List annotations = exposeObject && file.getTargetName().getPlatformType() == PlatformType.js ? BuildKonfigGeneratorKt.access$getJsObjectAnnotations() : CollectionsKt.emptyList();
            List list = CollectionsKt.listOf((Object)KModifier.ACTUAL);
            return new BuildKonfigGenerator(file, (List<AnnotationSpec>)annotations, (List<? extends KModifier>)objectModifiers, logger, list){

                public PropertySpec generateProp(FieldSpec fieldSpec) {
                    Intrinsics.checkNotNullParameter((Object)fieldSpec, (String)"fieldSpec");
                    Object[] objectArray = new Object[]{fieldSpec.getValue()};
                    PropertySpec.Builder spec = PropertySpec.Companion.builder(fieldSpec.getName(), fieldSpec.getTypeName(), new KModifier[0]).initializer(fieldSpec.getTemplate(), objectArray);
                    if (!fieldSpec.isTargetSpecific()) {
                        Collection $this$toTypedArray$iv = this.getPropertyModifiers();
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        objectArray = thisCollection$iv.toArray(new KModifier[0]);
                        spec.addModifiers((KModifier[])Arrays.copyOf(objectArray, objectArray.length));
                    }
                    if (fieldSpec.getConst()) {
                        objectArray = new KModifier[]{KModifier.CONST};
                        spec.addModifiers((KModifier[])objectArray);
                    }
                    return spec.build();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

