/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.EncryptedJson;
import com.codingrodent.jackson.crypto.EncryptionException;
import com.codingrodent.jackson.crypto.ICryptoContext;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseCryptoContext
implements ICryptoContext {
    private final byte[] iv;
    private final byte[] salt;
    private final SecretKeySpec writeSecretKeySpec;
    private final String readPassword;
    private final String cipherName;
    private final String keyAlgorithm;

    public BaseCryptoContext(String readPassword, String writePassword, String cipherName, String keyAlgorithm) {
        if (null == readPassword || null == writePassword) {
            throw new EncryptionException("Password cannot be null");
        }
        if (null == cipherName) {
            throw new EncryptionException("Cipher Name cannot be null");
        }
        if (null == keyAlgorithm) {
            throw new EncryptionException("Key Algorithm cannot be null");
        }
        this.readPassword = readPassword;
        this.cipherName = cipherName;
        this.keyAlgorithm = keyAlgorithm;
        this.salt = this.generateSalt(20);
        this.writeSecretKeySpec = this.createSecretKeySpec(this.salt, writePassword);
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            cipher.init(1, this.writeSecretKeySpec);
            AlgorithmParameters params = cipher.getParameters();
            this.iv = params.getParameterSpec(IvParameterSpec.class).getIV();
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] decrypt(EncryptedJson value) throws EncryptionException {
        try {
            return this.getDecryptCipher(value.getIv(), value.getSalt()).doFinal(value.getValue());
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] encrypt(byte[] source) throws EncryptionException {
        try {
            return this.getEncryptCipher().doFinal(source);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] getIv() {
        return Arrays.copyOf(this.iv, this.iv.length);
    }

    @Override
    public byte[] getSalt() {
        return Arrays.copyOf(this.salt, this.salt.length);
    }

    private Cipher getDecryptCipher(byte[] iv, byte[] salt) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            SecretKeySpec secretKeySpec = this.createSecretKeySpec(salt, this.readPassword);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private Cipher getEncryptCipher() throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
            cipher.init(1, (Key)this.writeSecretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private byte[] generateSalt(int size) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    private SecretKeySpec createSecretKeySpec(byte[] salt, String password) throws EncryptionException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.keyAlgorithm);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65556, 256);
            SecretKey secretKey = factory.generateSecret(spec);
            return new SecretKeySpec(secretKey.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}

