/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;

public class EncryptedJsonDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private final EncryptionService service;
    private final JsonDeserializer<Object> baseDeserializer;
    private final BeanProperty property;

    public EncryptedJsonDeserializer(EncryptionService service, JsonDeserializer<Object> baseDeserializer) {
        this.service = service;
        this.baseDeserializer = baseDeserializer;
        this.property = null;
    }

    public EncryptedJsonDeserializer(EncryptionService service, JsonDeserializer<Object> wrapped, BeanProperty property) {
        this.service = service;
        this.baseDeserializer = wrapped;
        this.property = property;
    }

    public Object deserialize(JsonParser parser, DeserializationContext context) throws JsonMappingException {
        JsonDeserializer deserializer = this.baseDeserializer;
        if (deserializer instanceof ContextualDeserializer) {
            deserializer = ((ContextualDeserializer)deserializer).createContextual(context, this.property);
        }
        return this.service.decrypt(parser, deserializer, context, this.property != null ? this.property.getType() : null);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        return new EncryptedJsonDeserializer(this.service, this.baseDeserializer, property);
    }
}

