/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.EncryptedJson;
import com.codingrodent.jackson.crypto.EncryptionException;
import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class EncryptedJsonSerializer
extends JsonSerializer<Object> {
    private final JsonSerializer<Object> baseSerializer;
    private final EncryptionService encryptionService;

    public EncryptedJsonSerializer(EncryptionService encryptionService, JsonSerializer<Object> baseSerializer) {
        this.encryptionService = encryptionService;
        this.baseSerializer = baseSerializer;
    }

    public void serialize(Object object, JsonGenerator generator, SerializerProvider provider) throws IOException, EncryptionException {
        StringWriter writer = new StringWriter();
        JsonGenerator nestedGenerator = generator.getCodec().getFactory().createGenerator((Writer)writer);
        if (null == this.baseSerializer) {
            provider.defaultSerializeValue(object, nestedGenerator);
        } else {
            this.baseSerializer.serialize(object, nestedGenerator, provider);
        }
        nestedGenerator.close();
        EncryptedJson encrypted = this.encryptionService.encrypt(writer.getBuffer().toString(), "UTF-8");
        generator.writeObject((Object)encrypted);
    }
}

