/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.Encrypt;
import com.codingrodent.jackson.crypto.EncryptedJsonSerializer;
import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ArrayList;
import java.util.List;

public class EncryptedSerializerModifier
extends BeanSerializerModifier {
    private final EncryptionService encryptionService;

    public EncryptedSerializerModifier(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDescription, List<BeanPropertyWriter> beanProperties) {
        ArrayList<BeanPropertyWriter> newWriters = new ArrayList<BeanPropertyWriter>();
        for (BeanPropertyWriter writer : beanProperties) {
            if (null == writer.getAnnotation(Encrypt.class)) {
                newWriters.add(writer);
                continue;
            }
            try {
                EncryptedJsonSerializer encryptSer = new EncryptedJsonSerializer(this.encryptionService, (JsonSerializer<Object>)writer.getSerializer());
                newWriters.add(new EncryptedPropertyWriter(writer, encryptSer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newWriters;
    }

    static class EncryptedPropertyWriter
    extends BeanPropertyWriter {
        EncryptedPropertyWriter(BeanPropertyWriter base, JsonSerializer<Object> deserializer) {
            super(base);
            this._serializer = deserializer;
        }
    }
}

