/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.CryptoModule;
import com.codingrodent.jackson.crypto.EncryptedJson;
import com.codingrodent.jackson.crypto.EncryptionException;
import com.codingrodent.jackson.crypto.ICryptoContext;
import com.codingrodent.jackson.crypto.PasswordCryptoContext;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionService {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionService.class);
    private final ObjectMapper mapper;
    private final Validator validator;
    private final ICryptoContext cryptoContext;

    public static ObjectMapper getInstance(ICryptoContext cryptoContext) {
        ObjectMapper objectMapper = new ObjectMapper();
        EncryptionService encryptionService = new EncryptionService(objectMapper, new PasswordCryptoContext("Password1"));
        objectMapper.registerModule((Module)new CryptoModule().addEncryptionService(encryptionService));
        return objectMapper;
    }

    public EncryptionService(ObjectMapper objectMapper, Validator validator, ICryptoContext cryptoContext) throws EncryptionException {
        if (null == objectMapper) {
            throw new EncryptionException("Object mapper cannot be null");
        }
        if (null == validator) {
            throw new EncryptionException("Validator cannot be null");
        }
        if (null == cryptoContext) {
            throw new EncryptionException("Crypto Context cannot be null");
        }
        this.mapper = objectMapper;
        this.validator = validator;
        this.cryptoContext = cryptoContext;
    }

    public EncryptionService(ObjectMapper objectMapper, ICryptoContext cryptoContext) throws EncryptionException {
        this(objectMapper, Validation.buildDefaultValidatorFactory().getValidator(), cryptoContext);
    }

    public EncryptedJson encrypt(byte[] data) throws EncryptionException {
        EncryptedJson result = new EncryptedJson();
        result.setIv(this.cryptoContext.getIv());
        result.setSalt(this.cryptoContext.getSalt());
        result.setValue(this.cryptoContext.encrypt(data));
        return result;
    }

    public EncryptedJson encrypt(String text, String encoding) throws EncryptionException {
        try {
            return this.encrypt(text.getBytes(encoding));
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    public byte[] decrypt(EncryptedJson value) {
        this.validate(value);
        return this.cryptoContext.decrypt(value);
    }

    public Object decrypt(JsonParser parser, JsonDeserializer<?> deserializer, DeserializationContext context, JavaType type) {
        try {
            return null == deserializer ? this.mapper.readValue(this.decrypt((EncryptedJson)this.mapper.readValue(parser, EncryptedJson.class)), type) : deserializer.deserialize(this.mapper.getFactory().createParser(this.decrypt((EncryptedJson)this.mapper.readValue(parser, EncryptedJson.class))), context);
        }
        catch (Exception e) {
            throw new EncryptionException("Unable to decrypt document", e);
        }
    }

    private void validate(EncryptedJson encrypted) throws EncryptionException {
        Set violations = this.validator.validate((Object)encrypted, new Class[0]);
        if (!violations.isEmpty()) {
            String message = "Encrypted JSON is invalid" + this.getErrors(violations);
            logger.error(message);
            throw new EncryptionException(message);
        }
    }

    private String getErrors(Set<ConstraintViolation<EncryptedJson>> violations) {
        StringBuilder sb = new StringBuilder();
        violations.forEach(violation -> sb.append(" - ").append(violation.getPropertyPath()).append(" ").append(violation.getMessage()));
        return sb.toString();
    }
}

