/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.OwnerIdPolicy;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SherlockDefaults;
import java.time.Duration;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DistributedLockBuilder<T> {
    private String lockId;
    private final LockCreator<T> lockCreator;
    private Duration duration = SherlockDefaults.DEFAULT_LOCK_DURATION;
    private OwnerIdPolicy ownerIdPolicy = OwnerIdPolicy.uniqueOwnerId();

    public DistributedLockBuilder(LockCreator<T> lockCreator) {
        this.lockCreator = lockCreator;
    }

    <R> DistributedLockBuilder<R> withMappedLock(Function<T, R> lockMapper) {
        return new DistributedLockBuilder<Object>((lockId, duration, ownerId) -> {
            T lock = this.lockCreator.createLock(lockId, duration, ownerId);
            return lockMapper.apply(lock);
        });
    }

    @NotNull
    public DistributedLockBuilder<T> withLockId(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        this.lockId = lockId;
        return this;
    }

    @NotNull
    public DistributedLockBuilder<T> withLockDuration(Duration duration) {
        if (duration != null) {
            Preconditions.expectTruncatedToMillis((Duration)duration, (String)"duration");
        }
        this.duration = duration;
        return this;
    }

    @NotNull
    public DistributedLockBuilder<T> withPermanentLockDuration() {
        return this.withLockDuration(null);
    }

    @NotNull
    public DistributedLockBuilder<T> withOwnerId(@NotNull String ownerId) {
        Preconditions.expectNonEmpty((String)ownerId, (String)"ownerId");
        return this.withOwnerIdPolicy(OwnerIdPolicy.staticOwnerId(ownerId));
    }

    @NotNull
    public DistributedLockBuilder<T> withUniqueOwnerId() {
        return this.withOwnerIdPolicy(OwnerIdPolicy.uniqueOwnerId());
    }

    @NotNull
    public DistributedLockBuilder<T> withStaticUniqueOwnerId() {
        return this.withOwnerIdPolicy(OwnerIdPolicy.staticUniqueOwnerId());
    }

    @NotNull
    public DistributedLockBuilder<T> withOwnerIdPolicy(OwnerIdPolicy ownerIdPolicy) {
        this.ownerIdPolicy = ownerIdPolicy;
        return this;
    }

    @NotNull
    public T build() {
        String ownerId = this.ownerIdPolicy.getOwnerId();
        Preconditions.expectNonEmpty((String)ownerId, (String)"ownerId");
        return this.lockCreator.createLock(this.lockId, this.duration, ownerId);
    }

    @FunctionalInterface
    public static interface LockCreator<T> {
        @NotNull
        public T createLock(@NotNull String var1, @Nullable Duration var2, @NotNull String var3);
    }
}

