/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.StaticOwnerIdPolicy;
import org.jetbrains.annotations.NotNull;

public interface OwnerIdPolicy {
    @NotNull
    public static OwnerIdPolicy defaultOwnerIdPolicy() {
        return OwnerIdPolicy.uniqueOwnerId();
    }

    @NotNull
    public static OwnerIdPolicy staticOwnerId(@NotNull String ownerId) {
        Preconditions.expectNonEmpty((String)ownerId, (String)"ownerId");
        return new StaticOwnerIdPolicy(ownerId);
    }

    @NotNull
    public static OwnerIdPolicy uniqueOwnerId() {
        return StaticOwnerIdPolicy.RANDOM_OWNER_ID_POLICY;
    }

    @NotNull
    public static OwnerIdPolicy staticUniqueOwnerId() {
        return StaticOwnerIdPolicy.RANDOM_STATIC_OWNER_ID_POLICY;
    }

    @NotNull
    public String getOwnerId();
}

