/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.connector;

import com.coditory.sherlock.connector.AcquireResultWithValue;
import java.util.Objects;

public final class AcquireResult {
    private static final AcquireResult ACQUIRED = new AcquireResult(true);
    private static final AcquireResult REJECTED = new AcquireResult(false);
    private final boolean acquired;

    public static AcquireResult of(boolean acquired) {
        return acquired ? ACQUIRED : REJECTED;
    }

    public static AcquireResult acquiredResult() {
        return ACQUIRED;
    }

    public static AcquireResult rejectedResult() {
        return REJECTED;
    }

    private AcquireResult(boolean acquired) {
        this.acquired = acquired;
    }

    public boolean acquired() {
        return this.acquired;
    }

    public boolean rejected() {
        return !this.acquired;
    }

    public AcquireResult onRejected(Runnable action) {
        if (!this.acquired) {
            action.run();
        }
        return this;
    }

    public AcquireResult onAcquired(Runnable action) {
        if (this.acquired) {
            action.run();
        }
        return this;
    }

    public AcquireResult onFinished(Runnable action) {
        action.run();
        return this;
    }

    public <T> AcquireResultWithValue<T> toAcquiredWithValue(T value) {
        if (this.acquired) {
            return AcquireResultWithValue.acquiredResult(value);
        }
        return AcquireResultWithValue.rejectedResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcquireResult that = (AcquireResult)o;
        return this.acquired == that.acquired;
    }

    public int hashCode() {
        return Objects.hash(this.acquired);
    }

    public String toString() {
        return "AcquireResult{acquired=" + this.acquired + "}";
    }
}

