/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.connector;

import com.coditory.sherlock.connector.AcquireResult;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class AcquireResultWithValue<T> {
    private static final AcquireResultWithValue<Object> ACQUIRED_EMPTY = new AcquireResultWithValue<Object>(true, null);
    private static final AcquireResultWithValue<Object> REJECTED = new AcquireResultWithValue<Object>(false, null);
    private final boolean acquired;
    private final T value;

    public static <T> AcquireResultWithValue<T> acquiredResult(T value) {
        return new AcquireResultWithValue<T>(true, value);
    }

    public static <T> AcquireResultWithValue<T> acquiredEmptyResult() {
        return ACQUIRED_EMPTY;
    }

    public static <T> AcquireResultWithValue<T> rejectedResult() {
        return REJECTED;
    }

    private AcquireResultWithValue(boolean acquired, T value) {
        this.acquired = acquired;
        this.value = value;
    }

    public boolean acquired() {
        return this.acquired;
    }

    public boolean rejected() {
        return !this.acquired;
    }

    public T value() {
        return this.value;
    }

    public AcquireResultWithValue<T> onRejected(Runnable action) {
        if (!this.acquired) {
            action.run();
        }
        return this;
    }

    public AcquireResultWithValue<T> onAcquired(Consumer<T> action) {
        if (this.acquired) {
            action.accept(this.value);
        }
        return this;
    }

    public <R> AcquireResultWithValue<R> mapAcquired(Function<T, R> action) {
        if (this.acquired) {
            R mapped = action.apply(this.value);
            return AcquireResultWithValue.acquiredResult(mapped);
        }
        return AcquireResultWithValue.rejectedResult();
    }

    public AcquireResultWithValue<T> onFinished(Runnable action) {
        action.run();
        return this;
    }

    public AcquireResult toAcquireResult() {
        return this.acquired ? AcquireResult.acquiredResult() : AcquireResult.rejectedResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcquireResultWithValue that = (AcquireResultWithValue)o;
        return this.acquired == that.acquired && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.acquired, this.value);
    }

    public String toString() {
        return "AcquireResultWithValue{acquired=" + this.acquired + ", value=" + String.valueOf(this.value) + "}";
    }
}

