/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.connector;

import java.util.Objects;

public final class InitializationResult {
    private static final InitializationResult INITIALIZED = new InitializationResult(true);
    private static final InitializationResult SKIPPED = new InitializationResult(false);
    private final boolean initialized;

    public static InitializationResult of(boolean initialized) {
        return initialized ? INITIALIZED : SKIPPED;
    }

    public static InitializationResult initializedResult() {
        return INITIALIZED;
    }

    public static InitializationResult skippedResult() {
        return SKIPPED;
    }

    private InitializationResult(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public InitializationResult onSkipped(Runnable action) {
        if (!this.initialized) {
            action.run();
        }
        return this;
    }

    public InitializationResult onInitialized(Runnable action) {
        if (this.initialized) {
            action.run();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitializationResult that = (InitializationResult)o;
        return this.initialized == that.initialized;
    }

    public int hashCode() {
        return Objects.hash(this.initialized);
    }

    public String toString() {
        return "InitializationResult{initialized=" + this.initialized + "}";
    }
}

