/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.connector;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.connector.AcquireResult;
import com.coditory.sherlock.connector.ReleaseResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockResultLogger {
    private final String lockId;
    private final Logger logger;

    public LockResultLogger(@NotNull String lockId, @NotNull Class<?> lockType) {
        Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        Preconditions.expectNonNull(lockType, (String)"lockType");
        this.lockId = lockId;
        this.logger = LoggerFactory.getLogger(lockType);
    }

    public void logResult(@NotNull AcquireResult result) {
        Preconditions.expectNonNull((Object)result, (String)"result");
        if (result.acquired()) {
            this.logger.debug("Lock acquired: {}", (Object)this.lockId);
        } else {
            this.logger.debug("Lock not acquired: {}", (Object)this.lockId);
        }
    }

    public void logResult(@NotNull ReleaseResult result) {
        Preconditions.expectNonNull((Object)result, (String)"result");
        if (result.released()) {
            this.logger.debug("Lock released: {}", (Object)this.lockId);
        } else {
            this.logger.debug("Lock not released: {}", (Object)this.lockId);
        }
    }
}

