/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.connector;

import java.util.Objects;

public final class ReleaseResult {
    private static final ReleaseResult RELEASED = new ReleaseResult(true);
    private static final ReleaseResult SKIPPED = new ReleaseResult(false);
    private final boolean released;

    public static ReleaseResult of(boolean released) {
        return released ? RELEASED : SKIPPED;
    }

    public static ReleaseResult releasedResult() {
        return RELEASED;
    }

    public static ReleaseResult skippedResult() {
        return SKIPPED;
    }

    private ReleaseResult(boolean released) {
        this.released = released;
    }

    public boolean released() {
        return this.released;
    }

    public ReleaseResult onSkipped(Runnable action) {
        if (!this.released) {
            action.run();
        }
        return this;
    }

    public ReleaseResult onReleased(Runnable action) {
        if (this.released) {
            action.run();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseResult that = (ReleaseResult)o;
        return this.released == that.released;
    }

    public int hashCode() {
        return Objects.hash(this.released);
    }

    public String toString() {
        return "ReleaseResult{released=" + this.released + "}";
    }
}

