/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.migrator;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class MigrationResult {
    private static final MigrationResult REJECTED = new MigrationResult(false, List.of());
    private static final MigrationResult ACQUIRED_EMPTY = new MigrationResult(true, List.of());
    private final boolean acquired;
    private final List<String> executedChangeSets;

    public static MigrationResult acquiredResult(List<String> executedChangeSets) {
        return new MigrationResult(true, executedChangeSets);
    }

    public static MigrationResult acquiredEmptyResult() {
        return ACQUIRED_EMPTY;
    }

    public static MigrationResult rejectedResult() {
        return REJECTED;
    }

    private MigrationResult(boolean acquired, List<String> executedChangeSets) {
        this.acquired = acquired;
        this.executedChangeSets = List.copyOf(executedChangeSets);
    }

    public boolean acquired() {
        return this.acquired;
    }

    public boolean rejected() {
        return !this.acquired;
    }

    public List<String> executedChangeSets() {
        return this.executedChangeSets;
    }

    public MigrationResult onAcquired(Consumer<List<String>> action) {
        if (this.acquired) {
            action.accept(this.executedChangeSets);
        }
        return this;
    }

    public MigrationResult onRejected(Runnable action) {
        if (!this.acquired) {
            action.run();
        }
        return this;
    }

    public MigrationResult onFinished(Runnable action) {
        action.run();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationResult that = (MigrationResult)o;
        return this.acquired == that.acquired && Objects.equals(this.executedChangeSets, that.executedChangeSets);
    }

    public int hashCode() {
        return Objects.hash(this.acquired, this.executedChangeSets);
    }

    public String toString() {
        return "MigrationResult{acquired=" + this.acquired + ", executedChangeSets=" + String.valueOf(this.executedChangeSets) + "}";
    }
}

