/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SherlockMigrator {
    private static final String DEFAULT_MIGRATOR_LOCK_ID = "migrator";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<MigrationChangeSet> migrationChangeSets = new ArrayList<MigrationChangeSet>();
    private final String migrationId;
    private final Sherlock sherlock;
    private final DistributedLock migrationLock;
    private final Set<String> migrationLockIds = new HashSet<String>();

    public SherlockMigrator(Sherlock sherlock) {
        this(DEFAULT_MIGRATOR_LOCK_ID, sherlock);
    }

    public SherlockMigrator(String migrationId, Sherlock sherlock) {
        this.migrationId = migrationId;
        this.sherlock = sherlock;
        this.migrationLock = (DistributedLock)sherlock.createLock().withLockId(migrationId).withPermanentLockDuration().withStaticUniqueOwnerId().build();
        this.migrationLockIds.add(migrationId);
    }

    public SherlockMigrator addChangeSet(String changeSetId, Runnable changeSet) {
        Preconditions.expectNonEmpty((String)changeSetId, (String)"Expected non empty changeSetId");
        this.ensureUniqueChangeSetId(changeSetId);
        this.migrationLockIds.add(changeSetId);
        DistributedLock changeSetLock = this.createChangeSetLock(changeSetId);
        this.migrationChangeSets.add(new MigrationChangeSet(changeSetId, changeSetLock, changeSet));
        return this;
    }

    private DistributedLock createChangeSetLock(String migrationId) {
        return (DistributedLock)this.sherlock.createLock().withLockId(migrationId).withPermanentLockDuration().withStaticUniqueOwnerId().build();
    }

    public MigrationResult migrate() {
        DistributedLock.AcquireAndExecuteResult acquireResult = this.migrationLock.acquireAndExecute(this::runMigrations);
        return new MigrationResult(acquireResult.isAcquired());
    }

    private void runMigrations() {
        Timer timer = Timer.start();
        this.logger.info("Starting migration: {}", (Object)this.migrationId);
        this.migrationChangeSets.forEach(MigrationChangeSet::execute);
        this.logger.info("Migration finished successfully: {} [{}]", (Object)this.migrationId, (Object)timer.elapsed());
    }

    private void ensureUniqueChangeSetId(String changeSetId) {
        if (this.migrationLockIds.contains(changeSetId)) {
            throw new IllegalArgumentException("Expected unique change set ids. Duplicated id: " + changeSetId);
        }
    }

    public static final class MigrationResult {
        private final boolean migrated;

        MigrationResult(boolean migrated) {
            this.migrated = migrated;
        }

        public boolean isMigrated() {
            return this.migrated;
        }

        public MigrationResult onFinish(Runnable action) {
            if (this.migrated) {
                action.run();
            }
            return this;
        }

        public MigrationResult onRejected(Runnable action) {
            if (!this.migrated) {
                action.run();
            }
            return this;
        }
    }

    private static class MigrationChangeSet {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final String id;
        private final DistributedLock lock;
        private final Runnable action;

        MigrationChangeSet(String id, DistributedLock lock, Runnable action) {
            this.id = id;
            this.lock = lock;
            this.action = action;
        }

        void execute() {
            Timer timer = Timer.start();
            if (this.lock.acquire()) {
                this.logger.debug("Executing migration change set: {}", (Object)this.id);
                try {
                    this.action.run();
                    this.logger.info("Migration change set applied: {} [{}]", (Object)this.id, (Object)timer.elapsed());
                }
                catch (Throwable exception) {
                    this.logger.warn("Migration change set failure: {} [{}]. Stopping migration process. Fix problem and rerun the migration.", new Object[]{this.id, timer.elapsed(), exception});
                    this.lock.release();
                    throw exception;
                }
            } else {
                this.logger.info("Migration change set skipped: {}", (Object)this.id);
            }
        }
    }
}

