/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.Preconditions;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatingDistributedLock
implements DistributedLock {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String lockId;
    private final String ownerId;
    private final Duration duration;
    private final AcquireAction acquireAction;
    private final ReleaseAction releaseAction;

    DelegatingDistributedLock(AcquireAction acquireAction, ReleaseAction releaseAction, String lockId, String ownerId, Duration duration) {
        this.lockId = (String)Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        this.ownerId = (String)Preconditions.expectNonNull((Object)ownerId, (String)"ownerId");
        this.duration = duration;
        this.acquireAction = (AcquireAction)Preconditions.expectNonNull((Object)acquireAction, (String)"acquireAction");
        this.releaseAction = (ReleaseAction)Preconditions.expectNonNull((Object)releaseAction, (String)"releaseAction");
    }

    @Override
    @NotNull
    public String getId() {
        return this.lockId;
    }

    @Override
    public boolean acquire() {
        return this.acquire(new LockRequest(this.lockId, this.ownerId, this.duration));
    }

    @Override
    public boolean acquire(@NotNull Duration duration) {
        Preconditions.expectNonNull((Object)duration, (String)"duration");
        return this.acquire(new LockRequest(this.lockId, this.ownerId, duration));
    }

    @Override
    public boolean acquireForever() {
        return this.acquire(new LockRequest(this.lockId, this.ownerId, null));
    }

    @Override
    public boolean release() {
        boolean released = this.releaseAction.release(this.lockId, this.ownerId);
        if (released) {
            this.logger.debug("Lock released: {}", (Object)this.lockId);
        } else {
            this.logger.debug("Lock not released: {}", (Object)this.lockId);
        }
        return released;
    }

    private boolean acquire(@NotNull LockRequest lockRequest) {
        boolean acquired = this.acquireAction.acquire(lockRequest);
        if (acquired) {
            this.logger.debug("Lock acquired: {}, {}", (Object)this.lockId, (Object)lockRequest);
        } else {
            this.logger.debug("Lock not acquired: {}, {}", (Object)this.lockId, (Object)lockRequest);
        }
        return acquired;
    }

    public String toString() {
        return "DelegatingDistributedLock{lockId=" + this.lockId + ", ownerId=" + this.ownerId + ", duration=" + String.valueOf(this.duration) + "}";
    }

    @FunctionalInterface
    public static interface AcquireAction {
        public boolean acquire(@NotNull LockRequest var1);
    }

    @FunctionalInterface
    public static interface ReleaseAction {
        public boolean release(@NotNull String var1, @NotNull String var2);
    }
}

