/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.connector.AcquireResult;
import com.coditory.sherlock.connector.AcquireResultWithValue;
import java.time.Duration;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface DistributedLock {
    @NotNull
    public String getId();

    public boolean acquire();

    public boolean acquire(@NotNull Duration var1);

    public boolean acquireForever();

    public boolean release();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> AcquireResultWithValue<T> runLocked(@NotNull Supplier<? extends T> supplier) {
        Preconditions.expectNonNull(supplier, (String)"supplier");
        if (this.acquire()) {
            try {
                T value = supplier.get();
                AcquireResultWithValue acquireResultWithValue = AcquireResultWithValue.acquiredResult(value);
                return acquireResultWithValue;
            }
            finally {
                this.release();
            }
        }
        return AcquireResultWithValue.rejectedResult();
    }

    default public AcquireResult runLocked(@NotNull Runnable runnable) {
        Preconditions.expectNonNull((Object)runnable, (String)"runnable");
        if (this.acquire()) {
            try {
                runnable.run();
                AcquireResult acquireResult = AcquireResult.acquiredResult();
                return acquireResult;
            }
            finally {
                this.release();
            }
        }
        return AcquireResult.rejectedResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public AcquireResult runLocked(@NotNull Duration duration, @NotNull Runnable runnable) {
        Preconditions.expectNonNull((Object)duration, (String)"duration");
        Preconditions.expectNonNull((Object)runnable, (String)"runnable");
        if (this.acquire(duration)) {
            try {
                runnable.run();
                AcquireResult acquireResult = AcquireResult.acquiredResult();
                return acquireResult;
            }
            finally {
                this.release();
            }
        }
        return AcquireResult.rejectedResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> AcquireResultWithValue<T> runLocked(@NotNull Duration duration, @NotNull Supplier<? extends T> supplier) {
        Preconditions.expectNonNull((Object)duration, (String)"duration");
        Preconditions.expectNonNull(supplier, (String)"supplier");
        if (this.acquire(duration)) {
            try {
                T value = supplier.get();
                AcquireResultWithValue acquireResultWithValue = AcquireResultWithValue.acquiredResult(value);
                return acquireResultWithValue;
            }
            finally {
                this.release();
            }
        }
        return AcquireResultWithValue.rejectedResult();
    }
}

