/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.DistributedLockBuilder;
import com.coditory.sherlock.Preconditions;
import org.jetbrains.annotations.NotNull;

public interface Sherlock {
    public void initialize();

    @NotNull
    public DistributedLockBuilder<DistributedLock> createLock();

    @NotNull
    default public DistributedLock createLock(@NotNull String lockId) {
        return (DistributedLock)this.createLock().withLockId(lockId).build();
    }

    @NotNull
    public DistributedLockBuilder<DistributedLock> createReentrantLock();

    @NotNull
    default public DistributedLock createReentrantLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return (DistributedLock)this.createReentrantLock().withLockId(lockId).build();
    }

    @NotNull
    public DistributedLockBuilder<DistributedLock> createOverridingLock();

    @NotNull
    default public DistributedLock createOverridingLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return (DistributedLock)this.createOverridingLock().withLockId(lockId).build();
    }

    public boolean forceReleaseAllLocks();

    default public boolean forceReleaseLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return this.createOverridingLock(lockId).release();
    }
}

