/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.OwnerIdPolicy;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnector;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public abstract class SherlockWithConnectorBuilder<T extends SherlockWithConnectorBuilder<?>> {
    private Duration duration = SherlockDefaults.DEFAULT_LOCK_DURATION;
    private OwnerIdPolicy ownerIdPolicy = OwnerIdPolicy.defaultOwnerIdPolicy();

    @NotNull
    public T withLockDuration(@NotNull Duration duration) {
        Preconditions.expectNonNull((Object)duration, (String)"duration");
        Preconditions.expectTruncatedToMillis((Duration)duration, (String)"duration");
        this.duration = duration;
        return this.instance();
    }

    @NotNull
    public T withOwnerId(@NotNull String ownerId) {
        Preconditions.expectNonNull((Object)ownerId, (String)"ownerId");
        this.ownerIdPolicy = OwnerIdPolicy.staticOwnerId((String)ownerId);
        return this.instance();
    }

    @NotNull
    public T withOwnerIdPolicy(@NotNull OwnerIdPolicy ownerIdPolicy) {
        this.ownerIdPolicy = ownerIdPolicy;
        return this.instance();
    }

    @NotNull
    public abstract Sherlock build();

    protected Sherlock build(DistributedLockConnector connector) {
        return new SherlockWithConnector(connector, this.ownerIdPolicy, this.duration);
    }

    private T instance() {
        return (T)this;
    }
}

