/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.migrator;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.migrator.ChangeSetMethodExtractor;
import com.coditory.sherlock.migrator.MigrationChangeSet;
import com.coditory.sherlock.migrator.MigrationResult;
import com.coditory.sherlock.migrator.SherlockMigrator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SherlockMigratorBuilder {
    private final List<SherlockMigrator.MigrationChangeSet> migrationChangeSets = new ArrayList<SherlockMigrator.MigrationChangeSet>();
    private final Set<String> migrationLockIds = new HashSet<String>();
    private final Sherlock sherlock;
    private String migrationId = "migrator";

    SherlockMigratorBuilder(@NotNull Sherlock sherlock) {
        Preconditions.expectNonNull((Object)sherlock, (String)"sherlock");
        this.sherlock = sherlock;
    }

    @NotNull
    public SherlockMigratorBuilder setMigrationId(@NotNull String migrationId) {
        Preconditions.expectNonEmpty((String)migrationId, (String)"migrationId");
        this.ensureUniqueChangeSetId(migrationId);
        this.migrationId = migrationId;
        return this;
    }

    @NotNull
    public SherlockMigratorBuilder addChangeSet(@NotNull String changeSetId, @NotNull Runnable changeSet) {
        Preconditions.expectNonEmpty((String)changeSetId, (String)"changeSetId");
        Preconditions.expectNonNull((Object)changeSet, (String)"changeSetId");
        this.ensureUniqueChangeSetId(changeSetId);
        DistributedLock changeSetLock = this.createChangeSetLock(changeSetId);
        SherlockMigrator.MigrationChangeSet migrationChangeSet = new SherlockMigrator.MigrationChangeSet(changeSetId, changeSetLock, changeSet);
        this.migrationChangeSets.add(migrationChangeSet);
        return this;
    }

    @NotNull
    public SherlockMigratorBuilder addAnnotatedChangeSets(@NotNull Object object) {
        Preconditions.expectNonNull((Object)object, (String)"object containing change sets");
        ChangeSetMethodExtractor.extractChangeSets((Object)object, Void.TYPE).forEach(changeSet -> this.addChangeSet(changeSet.getId(), () -> ((MigrationChangeSet)changeSet).execute()));
        return this;
    }

    @NotNull
    public SherlockMigrator build() {
        DistributedLock migrationLock = (DistributedLock)this.sherlock.createLock().withLockId(this.migrationId).withPermanentLockDuration().withStaticUniqueOwnerId().build();
        return new SherlockMigrator(migrationLock, this.migrationChangeSets);
    }

    @NotNull
    public MigrationResult migrate() {
        return this.build().migrate();
    }

    private DistributedLock createChangeSetLock(String migrationId) {
        return (DistributedLock)this.sherlock.createLock().withLockId(migrationId).withPermanentLockDuration().withStaticUniqueOwnerId().build();
    }

    private void ensureUniqueChangeSetId(String changeSetId) {
        if (this.migrationLockIds.contains(changeSetId)) {
            throw new IllegalArgumentException("Expected unique change set ids. Duplicated id: " + changeSetId);
        }
        this.migrationLockIds.add(changeSetId);
    }
}

