/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.test;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.UuidGenerator;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class DistributedLockMock
implements DistributedLock {
    private final DistributedLock lock;
    private final AtomicInteger releases = new AtomicInteger(0);
    private final AtomicInteger acquisitions = new AtomicInteger(0);
    private final AtomicInteger successfulReleases = new AtomicInteger(0);
    private final AtomicInteger successfulAcquisitions = new AtomicInteger(0);

    @NotNull
    public static DistributedLockMock releasedInMemoryLock() {
        return DistributedLockMock.releasedInMemoryLock(UuidGenerator.uuid());
    }

    @NotNull
    public static DistributedLockMock acquiredInMemoryLock() {
        return DistributedLockMock.acquiredInMemoryLock(UuidGenerator.uuid());
    }

    @NotNull
    public static DistributedLockMock releasedInMemoryLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.inMemoryLock(lockId, false);
    }

    @NotNull
    public static DistributedLockMock acquiredInMemoryLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.inMemoryLock(lockId, true);
    }

    private static DistributedLockMock inMemoryLock(@NotNull String lockId, boolean state) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.of(InMemoryDistributedLockStub.inMemoryLock(lockId, state));
    }

    @NotNull
    public static DistributedLockMock releasedReentrantInMemoryLock() {
        return DistributedLockMock.releasedReentrantInMemoryLock(UuidGenerator.uuid());
    }

    @NotNull
    public static DistributedLockMock acquiredReentrantInMemoryLock() {
        return DistributedLockMock.acquiredReentrantInMemoryLock(UuidGenerator.uuid());
    }

    @NotNull
    public static DistributedLockMock releasedReentrantInMemoryLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.reentrantInMemoryLock(lockId, false);
    }

    @NotNull
    public static DistributedLockMock acquiredReentrantInMemoryLock(@NotNull String lockId) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.reentrantInMemoryLock(lockId, true);
    }

    private static DistributedLockMock reentrantInMemoryLock(@NotNull String lockId, boolean state) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.of(InMemoryDistributedLockStub.reentrantInMemoryLock(lockId, state));
    }

    @NotNull
    public static DistributedLockMock lockStub(boolean result) {
        return DistributedLockMock.lockStub(UuidGenerator.uuid(), result, result);
    }

    @NotNull
    public static DistributedLockMock lockStub(boolean acquireResult, boolean releaseResult) {
        return DistributedLockMock.lockStub(UuidGenerator.uuid(), acquireResult, releaseResult);
    }

    @NotNull
    public static DistributedLockMock lockStub(@NotNull String lockId, boolean result) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        return DistributedLockMock.of(DistributedLockMock.lockStub(lockId, result, result));
    }

    @NotNull
    public static DistributedLockMock lockStub(@NotNull String lockId, boolean acquireResult, boolean releaseResult) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        SequencedDistributedLockStub lock = new SequencedDistributedLockStub(lockId, List.of(Boolean.valueOf(acquireResult)), List.of(Boolean.valueOf(releaseResult)));
        return DistributedLockMock.of(lock);
    }

    @NotNull
    public static DistributedLockMock sequencedLock(@NotNull List<Boolean> acquireResults, @NotNull List<Boolean> releaseResults) {
        Preconditions.expectNonNull(acquireResults, (String)"acquireResults");
        Preconditions.expectNonNull(releaseResults, (String)"releaseResults");
        return DistributedLockMock.sequencedLock(UuidGenerator.uuid(), acquireResults, releaseResults);
    }

    @NotNull
    public static DistributedLockMock sequencedLock(@NotNull String lockId, @NotNull List<Boolean> acquireResults, @NotNull List<Boolean> releaseResults) {
        Preconditions.expectNonEmpty((String)lockId, (String)"lockId");
        Preconditions.expectNonNull(acquireResults, (String)"acquireResults");
        Preconditions.expectNonNull(releaseResults, (String)"releaseResults");
        return DistributedLockMock.of(new SequencedDistributedLockStub(lockId, acquireResults, releaseResults));
    }

    private static DistributedLockMock of(DistributedLock lock) {
        return new DistributedLockMock(lock);
    }

    private DistributedLockMock(DistributedLock lock) {
        this.lock = lock;
    }

    @Override
    @NotNull
    public String getId() {
        return this.lock.getId();
    }

    @Override
    public boolean acquire() {
        return this.acquire(this.lock::acquire);
    }

    @Override
    public boolean acquire(@NotNull Duration duration) {
        Preconditions.expectNonNull((Object)duration, (String)"duration");
        return this.acquire(() -> this.lock.acquire(duration));
    }

    @Override
    public boolean acquireForever() {
        return this.acquire(this.lock::acquireForever);
    }

    private boolean acquire(Supplier<Boolean> acquireAction) {
        this.acquisitions.incrementAndGet();
        boolean result = acquireAction.get();
        if (result) {
            this.successfulAcquisitions.incrementAndGet();
        }
        return result;
    }

    @Override
    public boolean release() {
        this.releases.incrementAndGet();
        boolean result = this.lock.release();
        if (result) {
            this.successfulReleases.incrementAndGet();
        }
        return result;
    }

    public int successfulReleases() {
        return this.successfulReleases.get();
    }

    public int successfulAcquisitions() {
        return this.successfulAcquisitions.get();
    }

    public int releases() {
        return this.releases.get();
    }

    public int acquisitions() {
        return this.acquisitions.get();
    }

    public int rejectedReleases() {
        return this.releases() - this.successfulReleases();
    }

    public int rejectedAcquisitions() {
        return this.acquisitions() - this.successfulAcquisitions();
    }

    public boolean wasAcquired() {
        return this.successfulAcquisitions() > 0;
    }

    public boolean wasReleased() {
        return this.successfulReleases() > 0;
    }

    public boolean wasAcquiredAndReleased() {
        return this.wasAcquired() && this.wasReleased();
    }

    public boolean wasAcquireRejected() {
        return this.successfulAcquisitions() < this.acquisitions();
    }

    public boolean wasReleaseRejected() {
        return this.successfulReleases() < this.releases();
    }

    public boolean wasAcquireInvoked() {
        return this.acquisitions() > 0;
    }

    public boolean wasReleaseInvoked() {
        return this.releases() > 0;
    }

    private static class InMemoryDistributedLockStub
    implements DistributedLock {
        private final String lockId;
        private final boolean reentrant;
        private final AtomicBoolean acquired;

        static InMemoryDistributedLockStub reentrantInMemoryLock(String lockId, boolean acquired) {
            return new InMemoryDistributedLockStub(lockId, true, acquired);
        }

        static InMemoryDistributedLockStub inMemoryLock(String lockId, boolean acquired) {
            return new InMemoryDistributedLockStub(lockId, false, acquired);
        }

        private InMemoryDistributedLockStub(String lockId, boolean reentrant, boolean acquired) {
            this.lockId = (String)Preconditions.expectNonNull((Object)lockId, (String)"lockId");
            this.reentrant = reentrant;
            this.acquired = new AtomicBoolean(acquired);
        }

        @Override
        @NotNull
        public String getId() {
            return this.lockId;
        }

        @Override
        public boolean acquire() {
            if (this.reentrant) {
                this.acquired.set(true);
                return true;
            }
            return this.acquired.compareAndSet(false, true);
        }

        @Override
        public boolean acquire(@NotNull Duration duration) {
            Preconditions.expectNonNull((Object)duration, (String)"duration");
            return this.acquire();
        }

        @Override
        public boolean acquireForever() {
            return this.acquire();
        }

        @Override
        public boolean release() {
            return this.acquired.compareAndSet(true, false);
        }
    }

    static class SequencedDistributedLockStub
    implements DistributedLock {
        private final String lockId;
        private final ConcurrentLinkedQueue<Boolean> acquireResults;
        private final ConcurrentLinkedQueue<Boolean> releaseResults;
        private final boolean defaultAcquireResult;
        private final boolean defaultReleaseResult;

        private SequencedDistributedLockStub(String lockId, List<Boolean> acquireResults, List<Boolean> releaseResults) {
            Preconditions.expectNonNull((Object)lockId, (String)"lockId");
            Preconditions.expectNonEmpty(acquireResults, (String)"acquireResults");
            Preconditions.expectNonEmpty(releaseResults, (String)"releaseResults");
            this.lockId = (String)Preconditions.expectNonNull((Object)lockId, (String)"lockId");
            this.acquireResults = new ConcurrentLinkedQueue<Boolean>(acquireResults);
            this.releaseResults = new ConcurrentLinkedQueue<Boolean>(releaseResults);
            this.defaultAcquireResult = acquireResults.getLast();
            this.defaultReleaseResult = releaseResults.getLast();
        }

        @Override
        @NotNull
        public String getId() {
            return this.lockId;
        }

        @Override
        public boolean acquire() {
            return this.pollOrDefault(this.acquireResults, this.defaultAcquireResult);
        }

        @Override
        public boolean acquire(@NotNull Duration duration) {
            Preconditions.expectNonNull((Object)duration, (String)"duration");
            return this.acquire();
        }

        @Override
        public boolean acquireForever() {
            return this.acquire();
        }

        @Override
        public boolean release() {
            return this.pollOrDefault(this.releaseResults, this.defaultReleaseResult);
        }

        private boolean pollOrDefault(ConcurrentLinkedQueue<Boolean> queue, boolean defaultValue) {
            Boolean value = queue.poll();
            return value != null ? value : defaultValue;
        }
    }
}

