/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.migrator;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.Timer;
import com.coditory.sherlock.connector.AcquireResultWithValue;
import com.coditory.sherlock.migrator.MigrationResult;
import com.coditory.sherlock.migrator.SherlockMigratorBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SherlockMigrator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<MigrationChangeSet> migrationChangeSets;
    private final DistributedLock migrationLock;

    public static SherlockMigratorBuilder builder(@NotNull Sherlock sherlock) {
        return new SherlockMigratorBuilder(sherlock);
    }

    SherlockMigrator(@NotNull DistributedLock migrationLock, @NotNull List<MigrationChangeSet> migrationChangeSets) {
        Preconditions.expectNonNull((Object)migrationLock, (String)"migrationLock");
        Preconditions.expectNonNull(migrationChangeSets, (String)"migrationChangeSets");
        this.migrationLock = migrationLock;
        this.migrationChangeSets = List.copyOf(migrationChangeSets);
    }

    @NotNull
    public MigrationResult migrate() {
        AcquireResultWithValue<List> acquireResult = this.migrationLock.runLocked(this::runMigrations);
        if (!acquireResult.acquired()) {
            this.logger.debug("Migration skipped: {}. Migration lock was refused.", (Object)this.migrationLock.getId());
            return MigrationResult.rejectedResult();
        }
        return MigrationResult.acquiredResult((List)((List)acquireResult.value()));
    }

    private List<String> runMigrations() {
        Timer timer = Timer.start();
        this.logger.info("Migration started: {}", (Object)this.migrationLock.getId());
        List<String> result = this.migrationChangeSets.stream().filter(MigrationChangeSet::execute).map(MigrationChangeSet::id).toList();
        this.logger.info("Migration finished successfully: {} [{}]", (Object)this.migrationLock.getId(), (Object)timer.elapsed());
        return result;
    }

    static final class MigrationChangeSet {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final String id;
        private final DistributedLock lock;
        private final Runnable action;

        MigrationChangeSet(String id, DistributedLock lock, Runnable action) {
            this.id = id;
            this.lock = lock;
            this.action = action;
        }

        String id() {
            return this.id;
        }

        boolean execute() {
            Timer timer = Timer.start();
            if (this.lock.acquire()) {
                this.logger.debug("Executing migration change set: {}", (Object)this.id);
                try {
                    this.action.run();
                    this.logger.info("Migration change set applied: {} [{}]", (Object)this.id, (Object)timer.elapsed());
                    return true;
                }
                catch (Throwable exception) {
                    this.logger.warn("Migration change set failure: {} [{}]. Stopping migration process. Fix problem and rerun the migration.", new Object[]{this.id, timer.elapsed(), exception});
                    this.lock.release();
                    throw exception;
                }
            }
            this.logger.info("Migration change set skipped: {}", (Object)this.id);
            return false;
        }
    }
}

