/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.test;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.DistributedLockBuilder;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.test.DistributedLockMock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SherlockStub
implements Sherlock {
    private final Map<String, DistributedLock> locksById = new HashMap<String, DistributedLock>();
    private boolean defaultLockResult = true;

    @NotNull
    public static SherlockStub withReleasedLocks() {
        return new SherlockStub().withDefaultAcquireResult(true);
    }

    @NotNull
    public static SherlockStub withAcquiredLocks() {
        return new SherlockStub().withDefaultAcquireResult(false);
    }

    @NotNull
    public SherlockStub withLock(@NotNull DistributedLock lock) {
        Preconditions.expectNonNull((Object)lock, (String)"lock");
        this.locksById.put(lock.getId(), lock);
        return this;
    }

    private SherlockStub withDefaultAcquireResult(boolean result) {
        this.defaultLockResult = result;
        return this;
    }

    @Override
    public void initialize() {
    }

    @Override
    @NotNull
    public DistributedLockBuilder<DistributedLock> createLock() {
        return this.getLockOrDefault();
    }

    @Override
    @NotNull
    public DistributedLockBuilder<DistributedLock> createReentrantLock() {
        return this.getLockOrDefault();
    }

    @Override
    @NotNull
    public DistributedLockBuilder<DistributedLock> createOverridingLock() {
        return this.getLockOrDefault();
    }

    @Override
    public boolean forceReleaseAllLocks() {
        return false;
    }

    private DistributedLockBuilder<DistributedLock> getLockOrDefault() {
        return new DistributedLockBuilder(this::getLockOrDefault);
    }

    private DistributedLock getLockOrDefault(String id, Duration duration, String ownerId) {
        DistributedLockMock defaultLock = DistributedLockMock.lockStub(id, this.defaultLockResult);
        return this.locksById.getOrDefault(id, defaultLock);
    }
}

