/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.Preconditions;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LockRequest(@NotNull String lockId, @NotNull String ownerId, @Nullable Duration duration) {
    public LockRequest(@NotNull String lockId, @NotNull String ownerId, @Nullable Duration duration) {
        Preconditions.expectNonEmpty(lockId, "lockId");
        Preconditions.expectNonEmpty(ownerId, "ownerId");
        if (duration != null) {
            Preconditions.expectTruncatedToMillis(duration, "duration");
        }
    }

    public LockRequest(@NotNull String lockId, @NotNull String ownerId) {
        this(lockId, ownerId, null);
    }
}

