/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ports {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 49151;
    private static final AtomicInteger currentMinPort = new AtomicInteger(1100);
    private static final Logger LOG = LoggerFactory.getLogger(Ports.class);
    private static final ServerSocket LOCK;

    public static synchronized int getNextAvailable() {
        int next = Ports.getNextAvailable(currentMinPort.get());
        currentMinPort.set(next + 1);
        return next;
    }

    private static synchronized int getNextAvailable(int fromPort) {
        if (fromPort < currentMinPort.get() || fromPort > 49151) {
            throw new IllegalArgumentException("From port number not in valid range: " + fromPort);
        }
        for (int i = fromPort; i <= 49151; ++i) {
            if (!Ports.available(i)) continue;
            LOG.info("getNextAvailable({}) -> {}", (Object)fromPort, (Object)i);
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) throws IllegalArgumentException {
        if (port < currentMinPort.get() || port > 49151) {
            throw new IllegalArgumentException("Invalid start currentMinPort: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    static {
        int port = 1100;
        ServerSocket ss = null;
        while (ss == null) {
            try {
                ss = new ServerSocket(port);
            }
            catch (Exception e) {
                port += 200;
            }
        }
        LOCK = ss;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOCK.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        currentMinPort.set(port + 1);
    }
}

