/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.migrator;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.migrator.ChangeSet;
import com.coditory.sherlock.migrator.MigrationChangeSet;
import com.coditory.sherlock.migrator.MigrationChangeSetMethod;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class ChangeSetMethodExtractor {
    public static boolean isCoroutine(Method method) {
        int params = method.getParameterCount();
        return params >= 1 && Objects.equals(method.getParameterTypes()[params - 1].getCanonicalName(), "kotlin.coroutines.Continuation");
    }

    public static <R> List<MigrationChangeSetMethod<R>> extractChangeSetMethods(Object object, Class<R> expectedReturnType) {
        ArrayList<MigrationChangeSetMethod<R>> result = new ArrayList<MigrationChangeSetMethod<R>>();
        Map<ChangeSet, Method> changeSetMethods = ChangeSetMethodExtractor.extractAnnotatedChangeSetMethods(object, expectedReturnType);
        Preconditions.expectNonEmpty(changeSetMethods, "Expected at least one changeset method annotated with @ChangeSet");
        ArrayList<ChangeSet> annotations = new ArrayList<ChangeSet>(changeSetMethods.keySet());
        annotations.sort(Comparator.comparingInt(ChangeSet::order));
        ChangeSet lastChangeSet = null;
        for (ChangeSet changeSet : annotations) {
            if (lastChangeSet != null) {
                Preconditions.expect(lastChangeSet.order() < changeSet.order(), "Expected unique change set order values. Duplicated order value: " + changeSet.order(), new Object[0]);
            }
            result.add(new MigrationChangeSetMethod<R>(changeSet.id(), object, changeSetMethods.get(changeSet), expectedReturnType));
            lastChangeSet = changeSet;
        }
        return result;
    }

    public static <R> List<MigrationChangeSet<R>> extractChangeSets(Object object, Class<R> expectedReturnType) {
        return ChangeSetMethodExtractor.extractChangeSetMethods(object, expectedReturnType).stream().map(MigrationChangeSet::from).toList();
    }

    public static <R> List<MigrationChangeSet<R>> extractChangeSets(Object object, ChangeSetMapper<R> mapper) {
        ArrayList<MigrationChangeSet<R>> result = new ArrayList<MigrationChangeSet<R>>();
        Map<ChangeSet, Method> changeSetMethods = ChangeSetMethodExtractor.extractAnnotatedChangeSetMethods(object, null);
        Preconditions.expectNonEmpty(changeSetMethods, "Expected at least one changeset method annotated with @ChangeSet");
        ArrayList<ChangeSet> annotations = new ArrayList<ChangeSet>(changeSetMethods.keySet());
        annotations.sort(Comparator.comparingInt(ChangeSet::order));
        ChangeSet lastChangeSet = null;
        for (ChangeSet changeSet : annotations) {
            if (lastChangeSet != null) {
                Preconditions.expect(lastChangeSet.order() < changeSet.order(), "Expected unique change set order values. Duplicated order value: " + changeSet.order(), new Object[0]);
            }
            Method method = changeSetMethods.get(changeSet);
            Supplier<R> action = ChangeSetMethodExtractor.invokeMethod(method, object, null);
            try {
                Supplier<R> mappedAction = mapper.map(action, method.getReturnType());
                result.add(new MigrationChangeSet<R>(changeSet.id(), mappedAction));
                lastChangeSet = changeSet;
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Invalid migration method return type. Method:" + method.getName() + " return type: " + String.valueOf(method.getReturnType()), e);
            }
        }
        return result;
    }

    private static Map<ChangeSet, Method> extractAnnotatedChangeSetMethods(Object object, Class<?> expectedReturnType) {
        Method[] methods;
        HashMap<ChangeSet, Method> changeSetMethods = new HashMap<ChangeSet, Method>();
        for (Method method : methods = object.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ChangeSet.class)) continue;
            if (!method.accessFlags().contains((Object)AccessFlag.PUBLIC)) {
                throw new IllegalArgumentException("Method annotated with @ChangeSet should be public. Method: " + String.valueOf(method));
            }
            ChangeSet changeSet = method.getAnnotation(ChangeSet.class);
            ChangeSetMethodExtractor.validateAnnotatedChangeSet(changeSet, method, expectedReturnType);
            changeSetMethods.put(changeSet, method);
        }
        return changeSetMethods;
    }

    private static void validateAnnotatedChangeSet(ChangeSet changeSet, Method method, Class<?> expectedReturnType) {
        int paramCount = method.getParameterCount();
        boolean isCoroutine = ChangeSetMethodExtractor.isCoroutine(method);
        if (isCoroutine) {
            --paramCount;
        }
        Preconditions.expectEqual(paramCount, 0, "Expected no declared parameters for method " + method.getName());
        if (expectedReturnType != null && !isCoroutine) {
            Preconditions.expect(expectedReturnType.isAssignableFrom(method.getReturnType()), "Expected method to declare " + String.valueOf(method.getReturnType()) + " as return type. Method:" + method.getName() + " return type: " + String.valueOf(method.getReturnType()), new Object[0]);
        }
        Preconditions.expect(changeSet.order() >= 0, "Expected changeset order >= 0. Method:" + method.getName(), new Object[0]);
        Preconditions.expectNonEmpty(changeSet.id(), "Expected non-empty changeset id. Method:" + method.getName());
    }

    public static <R> Supplier<R> invokeMethod(Method method, Object object, Class<R> expectedReturnType) {
        return () -> {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke changeset method: " + method.getName(), e);
            }
        };
    }

    @FunctionalInterface
    public static interface ChangeSetMapper<R> {
        public Supplier<R> map(Supplier<?> var1, Class<?> var2);
    }
}

