/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.mongo;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SherlockException;
import com.coditory.sherlock.mongo.MongoCollectionInitializer;
import com.coditory.sherlock.mongo.MongoDistributedLock;
import com.coditory.sherlock.mongo.MongoDistributedLockQueries;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import java.time.Clock;
import java.time.Instant;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;

class MongoDistributedLockConnector
implements DistributedLockConnector {
    private static final int DUPLICATE_KEY_ERROR_CODE = 11000;
    private static final FindOneAndReplaceOptions upsertOptions = new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
    private final MongoCollectionInitializer collectionInitializer;
    private final Clock clock;

    MongoDistributedLockConnector(MongoCollection<Document> collection, Clock clock) {
        Preconditions.expectNonNull(collection, (String)"collection");
        Preconditions.expectNonNull((Object)clock, (String)"clock");
        this.collectionInitializer = new MongoCollectionInitializer(collection);
        this.clock = clock;
    }

    public void initialize() {
        try {
            this.collectionInitializer.getInitializedCollection();
        }
        catch (Throwable e) {
            throw new SherlockException("Could not initialize Mongo collection", e);
        }
    }

    public boolean acquire(@NotNull LockRequest lockRequest) {
        Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
        Instant now = this.now();
        try {
            return this.upsert(MongoDistributedLockQueries.queryReleased((String)lockRequest.lockId(), (Instant)now), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)now));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire lock: " + String.valueOf(lockRequest), e);
        }
    }

    public boolean acquireOrProlong(@NotNull LockRequest lockRequest) {
        Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
        Instant now = this.now();
        try {
            return this.upsert(MongoDistributedLockQueries.queryAcquiredOrReleased((String)lockRequest.lockId(), (String)lockRequest.ownerId(), (Instant)now), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)now));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire or prolong lock: " + String.valueOf(lockRequest), e);
        }
    }

    public boolean forceAcquire(@NotNull LockRequest lockRequest) {
        Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
        try {
            return this.upsert(MongoDistributedLockQueries.queryById((String)lockRequest.lockId()), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)this.now()));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire or prolong lock: " + String.valueOf(lockRequest), e);
        }
    }

    public boolean release(@NotNull String lockId, @NotNull String ownerId) {
        Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        Preconditions.expectNonNull((Object)ownerId, (String)"ownerId");
        try {
            return this.delete(MongoDistributedLockQueries.queryAcquired((String)lockId, (String)ownerId));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not release lock: " + lockId + ", owner: " + ownerId, e);
        }
    }

    public boolean forceRelease(@NotNull String lockId) {
        Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        try {
            return this.delete(MongoDistributedLockQueries.queryById((String)lockId));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release lock: " + lockId, e);
        }
    }

    public boolean forceReleaseAll() {
        try {
            return this.deleteAll();
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release all locks", e);
        }
    }

    private boolean deleteAll() {
        DeleteResult result = this.getLockCollection().deleteMany((Bson)new BsonDocument());
        return result.getDeletedCount() > 0L;
    }

    private boolean delete(Bson query) {
        Document deleted = (Document)this.getLockCollection().findOneAndDelete(query);
        return deleted != null && MongoDistributedLock.fromDocument((Document)deleted).isActive(this.now());
    }

    private boolean upsert(Bson query, MongoDistributedLock lock) {
        Document documentToUpsert = lock.toDocument();
        try {
            Document current = (Document)this.getLockCollection().findOneAndReplace(query, (Object)documentToUpsert, upsertOptions);
            return lock.hasSameOwner(current);
        }
        catch (MongoCommandException exception) {
            if (exception.getErrorCode() != 11000) {
                throw exception;
            }
            return false;
        }
    }

    private Instant now() {
        return this.clock.instant();
    }

    private MongoCollection<Document> getLockCollection() {
        return this.collectionInitializer.getInitializedCollection();
    }
}

