/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.mongo;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.coditory.sherlock.mongo.MongoDistributedLockConnector;
import com.mongodb.client.MongoCollection;
import java.time.Clock;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

public final class MongoSherlock
extends SherlockWithConnectorBuilder<MongoSherlock> {
    private MongoCollection<Document> collection;
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;

    @NotNull
    public static MongoSherlock builder() {
        return new MongoSherlock();
    }

    @NotNull
    public static Sherlock create(@NotNull MongoCollection<Document> collection) {
        Preconditions.expectNonNull(collection, (String)"collection");
        return MongoSherlock.builder().withLocksCollection(collection).build();
    }

    private MongoSherlock() {
    }

    @NotNull
    public MongoSherlock withLocksCollection(@NotNull MongoCollection<Document> collection) {
        this.collection = (MongoCollection)Preconditions.expectNonNull(collection, (String)"collection");
        return this;
    }

    @NotNull
    public MongoSherlock withClock(@NotNull Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"clock");
        return this;
    }

    @NotNull
    public Sherlock build() {
        Preconditions.expectNonNull(this.collection, (String)"collection");
        MongoDistributedLockConnector connector = new MongoDistributedLockConnector(this.collection, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

