/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.sql.BindingParameter;
import com.coditory.sherlock.sql.BindingParameterMapping;
import org.jetbrains.annotations.NotNull;

public interface BindingMapper {
    public static final BindingMapper ORDERED_QUESTION_MARK = param -> new BindingParameterMapping("?", param.getIndex());
    public static final BindingMapper INDEXED_QUESTION_MARK = param -> {
        int oneBasedIndex = param.getIndex() + 1;
        String value = "$" + oneBasedIndex;
        return new BindingParameterMapping(value, value);
    };
    public static final BindingMapper AT_NAME_MARK = param -> {
        String queryKey = "@" + param.getName();
        return new BindingParameterMapping(queryKey, param.getName());
    };
    public static final BindingMapper MYSQL_MAPPER = ORDERED_QUESTION_MARK;
    public static final BindingMapper POSTGRES_MAPPER = INDEXED_QUESTION_MARK;
    public static final BindingMapper H2_MAPPER = INDEXED_QUESTION_MARK;
    public static final BindingMapper MSSQL_MAPPER = AT_NAME_MARK;
    public static final BindingMapper SPANNER_MAPPER = AT_NAME_MARK;
    public static final BindingMapper JDBC_MAPPER = ORDERED_QUESTION_MARK;

    @NotNull
    default public BindingParameterMapping mapBinding(int index, @NotNull String name) {
        Preconditions.expect((index >= 0 ? 1 : 0) != 0, (String)"Expected index >= 0. Got: %d", (Object[])new Object[]{index});
        Preconditions.expectNonNull((Object)name, (String)"name");
        return this.mapBinding(new BindingParameter(index, name));
    }

    @NotNull
    public BindingParameterMapping mapBinding(@NotNull BindingParameter var1);
}

