/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.sql.BindingMapper;
import com.coditory.sherlock.sql.BindingParameter;
import com.coditory.sherlock.sql.BindingParameterMapping;
import com.coditory.sherlock.sql.SqlLockNamedQueriesTemplate;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PrecomputedBindingParameterMapper
implements BindingMapper {
    private final Map<BindingParameter, BindingParameterMapping> mapping;

    @NotNull
    public static PrecomputedBindingParameterMapper from(@NotNull BindingMapper mapper) {
        Preconditions.expectNonNull((Object)mapper, (String)"mapper");
        HashMap<BindingParameter, BindingParameterMapping> result = new HashMap<BindingParameter, BindingParameterMapping>();
        for (String param : SqlLockNamedQueriesTemplate.ParameterNames.ALL_PARAMS) {
            for (int i = 0; i < 10; ++i) {
                BindingParameter bindingParameter = new BindingParameter(i, param);
                BindingParameterMapping mapping = mapper.mapBinding(bindingParameter);
                result.put(bindingParameter, mapping);
            }
        }
        return new PrecomputedBindingParameterMapper(result);
    }

    private PrecomputedBindingParameterMapper(Map<BindingParameter, BindingParameterMapping> mapping) {
        this.mapping = mapping;
    }

    @NotNull
    public BindingParameterMapping mapBinding(@NotNull BindingParameter bindingParameter) {
        BindingParameterMapping result = this.mapping.get(bindingParameter);
        if (result == null) {
            throw new IllegalArgumentException("Could not find precomputed binding parameter for: " + String.valueOf(bindingParameter));
        }
        return result;
    }
}

