/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.sql.BindingMapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlLockNamedQueriesTemplate {
    private final String tableName;
    private final BindingMapper parameterMapper;

    public SqlLockNamedQueriesTemplate(@NotNull String tableName, @NotNull BindingMapper bindingMapper) {
        Preconditions.expectNonEmpty((String)tableName, (String)"tableName");
        Preconditions.expectNonNull((Object)bindingMapper, (String)"bindingMapper");
        this.tableName = this.expectValidTableName(tableName);
        this.parameterMapper = bindingMapper;
    }

    private String expectValidTableName(String tableName) {
        if (!tableName.matches("[a-zA-Z0-9_]+")) {
            throw new IllegalArgumentException("Expected table name consisting of a-z, A-Z, 0-9, _. Got: " + tableName);
        }
        return tableName;
    }

    public String createLocksTable() {
        return "CREATE TABLE " + this.tableName + "(  ID VARCHAR(100) NOT NULL,  ACQUIRED_BY VARCHAR(100) NOT NULL,  ACQUIRED_AT TIMESTAMP(3) NOT NULL,  EXPIRES_AT TIMESTAMP(3),  PRIMARY KEY (ID))";
    }

    public String createLocksIndex() {
        return "CREATE INDEX " + this.tableName + "_IDX ON " + this.tableName + " (ID, ACQUIRED_BY, EXPIRES_AT)";
    }

    public String checkTableExits() {
        return "SELECT 1 FROM " + this.tableName + " WHERE 1=2";
    }

    public String deleteAll() {
        return "DELETE FROM " + this.tableName;
    }

    public String deleteAcquiredByIdAndOwnerId() {
        return String.format("DELETE FROM %s WHERE ID = %s AND ACQUIRED_BY = %s AND (EXPIRES_AT IS NULL OR EXPIRES_AT > %s)", this.tableName, this.getMarker(0, "lockId"), this.getMarker(1, "ownerId"), this.getMarker(2, "now"));
    }

    public String deleteAcquiredById() {
        return String.format("DELETE FROM %s WHERE ID = %s AND (EXPIRES_AT IS NULL OR EXPIRES_AT > %s)", this.tableName, this.getMarker(0, "lockId"), this.getMarker(1, "now"));
    }

    public String updateLockById() {
        return String.format("UPDATE %s SET ACQUIRED_BY = %s, ACQUIRED_AT = %s, EXPIRES_AT = %s WHERE ID = %s", this.tableName, this.getMarker(0, "ownerId"), this.getMarker(1, "now"), this.getMarker(2, "expiresAt"), this.getMarker(3, "lockId"));
    }

    public String updateAcquiredOrReleasedLock() {
        return String.format("UPDATE %s SET ACQUIRED_BY = %s, ACQUIRED_AT = %s, EXPIRES_AT = %s WHERE ID = %s AND (ACQUIRED_BY = %s OR EXPIRES_AT <= %s)", this.tableName, this.getMarker(0, "ownerId"), this.getMarker(1, "now"), this.getMarker(2, "expiresAt"), this.getMarker(3, "lockId"), this.getMarker(4, "ownerId"), this.getMarker(5, "now"));
    }

    public String updateReleasedLock() {
        return String.format("UPDATE %s SET ACQUIRED_BY = %s, ACQUIRED_AT = %s, EXPIRES_AT = %s WHERE ID = %s AND EXPIRES_AT <= %s", this.tableName, this.getMarker(0, "ownerId"), this.getMarker(1, "now"), this.getMarker(2, "expiresAt"), this.getMarker(3, "lockId"), this.getMarker(4, "now"));
    }

    public String insertLock() {
        return String.format("INSERT INTO %s (ID, ACQUIRED_BY, ACQUIRED_AT, EXPIRES_AT) VALUES (%s, %s, %s, %s)", this.tableName, this.getMarker(0, "lockId"), this.getMarker(1, "ownerId"), this.getMarker(2, "now"), this.getMarker(3, "expiresAt"));
    }

    private String getMarker(int index, String name) {
        return this.parameterMapper.mapBinding(index, name).getQueryMarker();
    }

    public static final class ParameterNames {
        public static final String LOCK_ID = "lockId";
        public static final String OWNER_ID = "ownerId";
        public static final String EXPIRES_AT = "expiresAt";
        public static final String NOW = "now";
        public static final List<String> ALL_PARAMS = List.of("lockId", "ownerId", "expiresAt", "now");
    }
}

