/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.sql.BindingMapper;
import com.coditory.sherlock.sql.SqlLockNamedQueriesTemplate;
import org.jetbrains.annotations.NotNull;

public final class SqlLockQueries {
    private final String createLocksTableSql;
    private final String createLocksIndexSql;
    private final String checkTableExitsSql;
    private final String deleteAllSql;
    private final String deleteAcquiredByIdAndOwnerIdSql;
    private final String deleteAcquiredByIdSql;
    private final String updateLockByIdSql;
    private final String updateAcquiredOrReleasedLockSql;
    private final String updateReleasedLockSql;
    private final String insertLockSql;

    public SqlLockQueries(@NotNull String tableName) {
        this(tableName, BindingMapper.JDBC_MAPPER);
    }

    public SqlLockQueries(@NotNull String tableName, @NotNull BindingMapper bindingMapper) {
        Preconditions.expectNonEmpty((String)tableName, (String)"tableName");
        Preconditions.expectNonNull((Object)bindingMapper, (String)"bindingMapper");
        SqlLockNamedQueriesTemplate queriesTemplate = new SqlLockNamedQueriesTemplate(tableName, bindingMapper);
        this.createLocksTableSql = queriesTemplate.createLocksTable();
        this.createLocksIndexSql = queriesTemplate.createLocksIndex();
        this.checkTableExitsSql = queriesTemplate.checkTableExits();
        this.deleteAllSql = queriesTemplate.deleteAll();
        this.deleteAcquiredByIdAndOwnerIdSql = queriesTemplate.deleteAcquiredByIdAndOwnerId();
        this.deleteAcquiredByIdSql = queriesTemplate.deleteAcquiredById();
        this.updateLockByIdSql = queriesTemplate.updateLockById();
        this.updateAcquiredOrReleasedLockSql = queriesTemplate.updateAcquiredOrReleasedLock();
        this.updateReleasedLockSql = queriesTemplate.updateReleasedLock();
        this.insertLockSql = queriesTemplate.insertLock();
    }

    @NotNull
    public String createLocksTable() {
        return this.createLocksTableSql;
    }

    @NotNull
    public String createLocksIndex() {
        return this.createLocksIndexSql;
    }

    @NotNull
    public String checkTableExits() {
        return this.checkTableExitsSql;
    }

    @NotNull
    public String deleteAll() {
        return this.deleteAllSql;
    }

    @NotNull
    public String deleteAcquiredByIdAndOwnerId() {
        return this.deleteAcquiredByIdAndOwnerIdSql;
    }

    @NotNull
    public String deleteAcquiredById() {
        return this.deleteAcquiredByIdSql;
    }

    @NotNull
    public String updateLockById() {
        return this.updateLockByIdSql;
    }

    @NotNull
    public String updateAcquiredOrReleasedLock() {
        return this.updateAcquiredOrReleasedLockSql;
    }

    @NotNull
    public String updateReleasedLock() {
        return this.updateReleasedLockSql;
    }

    @NotNull
    public String insertLock() {
        return this.insertLockSql;
    }
}

