/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.ConnectionPool;
import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.coditory.sherlock.SqlDistributedLockConnector;
import java.sql.Connection;
import java.time.Clock;
import javax.sql.DataSource;

public final class SqlSherlockBuilder
extends SherlockWithConnectorBuilder<SqlSherlockBuilder> {
    public static final String DEFAULT_LOCKS_TABLE_NAME = "locks";
    private String tableName = "locks";
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;
    private ConnectionPool connectionPool;

    public static SqlSherlockBuilder sqlSherlock() {
        return new SqlSherlockBuilder();
    }

    @Deprecated(since="0.4.17")
    public static Sherlock sqlSherlock(Connection connection) {
        return SqlSherlockBuilder.sqlSherlock().withConnection(connection).build();
    }

    public static Sherlock sqlSherlock(DataSource connectionPool) {
        return SqlSherlockBuilder.sqlSherlock().withConnectionPool(connectionPool).build();
    }

    private SqlSherlockBuilder() {
    }

    @Deprecated(since="0.4.17")
    public SqlSherlockBuilder withConnection(Connection connection) {
        Preconditions.expectNonNull((Object)connection, (String)"Expected non null connection");
        this.connectionPool = ConnectionPool.of(connection);
        return this;
    }

    public SqlSherlockBuilder withConnectionPool(DataSource connectionPool) {
        Preconditions.expectNonNull((Object)connectionPool, (String)"Expected non null connectionPool");
        this.connectionPool = ConnectionPool.of(connectionPool);
        return this;
    }

    public SqlSherlockBuilder withLocksTable(String tableName) {
        this.tableName = Preconditions.expectNonEmpty((String)tableName, (String)"Expected non empty tableName");
        return this;
    }

    public SqlSherlockBuilder withClock(Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        return this;
    }

    public Sherlock build() {
        Preconditions.expectNonNull((Object)this.connectionPool, (String)"connectionPool");
        SqlDistributedLockConnector connector = new SqlDistributedLockConnector(this.connectionPool, this.tableName, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

